 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kbessel
   >>>> 
   >>>>    Written By: Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kbessel_h_
#define _kbessel_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kbessel/uis/kbessel.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input data object (required infile)
 */
char	*i_file;	/* input data object FILENAME */
int	 i_flag;	/* input data object FLAG */

/*
 *  resulting output data object (required outfile)
 */
char	*o_file;	/* resulting output data object FILENAME */
int	 o_flag;	/* resulting output data object FLAG */

/*----- required ME group ----*/
/*
 *  Bessel function of the first kind (optional flag)
 */
int	 j_flag;  	/* Bessel function of the first kind FLAG */

/*
 *  Bessel function of the second kind (optional flag)
 */
int	 y_flag;  	/* Bessel function of the second kind FLAG */

/*-- required ME group end ---*/

/*----- required ME group ----*/
/*
 *  Compute Bessel function of order 0 (optional flag)
 */
int	 ord0_flag;  	/* Compute Bessel function of order 0 FLAG */

/*
 *  Compute Bessel function of order 1 (optional flag)
 */
int	 ord1_flag;  	/* Compute Bessel function of order 1 FLAG */

/*
 *  Compute Bessel function of specified order (optional integer)
 */
int	 order_int; 	/* Compute Bessel function of specified order INT */
int	 order_flag;	/* Compute Bessel function of specified order FLAG */

/*-- required ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kbessel_get_args PROTO((kform *));
void kbessel_usage_additions PROTO((void));
void kbessel_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
