 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kaxis.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kaxis_get_args
| 
|       Purpose: Gets command line args for kaxis
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kaxis
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kaxis_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kaxis is out of sync with arguments specified in kaxis's *.pane file; please rerun ghostwriter on kaxis.";


	/*
	 * allocate the kaxis structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ww",
			  &(clui_info->ww_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "wh",
			  &(clui_info->wh_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "wd",
			  &(clui_info->wd_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hw",
			  &(clui_info->hw_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hh",
			  &(clui_info->hh_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hd",
			  &(clui_info->hd_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "dw",
			  &(clui_info->dw_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "dh",
			  &(clui_info->dh_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "dd",
			  &(clui_info->dd_flag))))
	{
	    kerror(NULL, "kaxis_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



