 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kasc2mask
   >>>> 
   >>>>    Written By: John M. Salas, Donna Koechner & John Rasure
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kasc2mask_h_
#define _kasc2mask_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "ksegops/ksegops.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kasc2mask/uis/kasc2mask.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  ASCII input data file containing new data segment (required infile)
 */
char	*i1_file;	/* ASCII input data file containing new data segment FILENAME */
int	 i1_flag;	/* ASCII input data file containing new data segment FLAG */

/*
 *  output data object (required outfile)
 */
char	*o_file;	/* output data object FILENAME */
int	 o_flag;	/* output data object FLAG */

/*
 *  data object input to insert the new segment into (optional infile)
 */
char	*i2_file;	/* data object input to insert the new segment into FILENAME */
int	 i2_flag;	/* data object input to insert the new segment into FLAG */

/*
 *  starting point in ASCII file to start importing at (optional integer)
 */
int	 so_int; 	/* starting point in ASCII file to start importing at INT */
int	 so_flag;	/* starting point in ASCII file to start importing at FLAG */

/*
 *  number of points in ASCII file to skip between reads (optional integer)
 */
int	 sf_int; 	/* number of points in ASCII file to skip between reads INT */
int	 sf_flag;	/* number of points in ASCII file to skip between reads FLAG */

/*
 *  width size must be > 0 (optional integer)
 */
int	 wsize_int; 	/* width size must be > 0 INT */
int	 wsize_flag;	/* width size must be > 0 FLAG */

/*
 *  position in the index order for the width dimension (Optional list)
 */
int	 windex_list;	/* position in the index order for the width dimension LIST INDEX */
char	 *windex_label;	/* position in the index order for the width dimension LIST LABEL */
int	 windex_flag;	/* position in the index order for the width dimension FLAG */

/*
 *  height size must be > 0 (optional integer)
 */
int	 hsize_int; 	/* height size must be > 0 INT */
int	 hsize_flag;	/* height size must be > 0 FLAG */

/*
 *  position in the index order for the height dimension (Optional list)
 */
int	 hindex_list;	/* position in the index order for the height dimension LIST INDEX */
char	 *hindex_label;	/* position in the index order for the height dimension LIST LABEL */
int	 hindex_flag;	/* position in the index order for the height dimension FLAG */

/*
 *  depth size must be > 0 (optional integer)
 */
int	 dsize_int; 	/* depth size must be > 0 INT */
int	 dsize_flag;	/* depth size must be > 0 FLAG */

/*
 *  position in the index order for the depth dimension (Optional list)
 */
int	 dindex_list;	/* position in the index order for the depth dimension LIST INDEX */
char	 *dindex_label;	/* position in the index order for the depth dimension LIST LABEL */
int	 dindex_flag;	/* position in the index order for the depth dimension FLAG */

/*
 *  time size must be > 0 (optional integer)
 */
int	 tsize_int; 	/* time size must be > 0 INT */
int	 tsize_flag;	/* time size must be > 0 FLAG */

/*
 *  position in the index order for the time dimension (Optional list)
 */
int	 tindex_list;	/* position in the index order for the time dimension LIST INDEX */
char	 *tindex_label;	/* position in the index order for the time dimension LIST LABEL */
int	 tindex_flag;	/* position in the index order for the time dimension FLAG */

/*
 *  elements size must be > 0 (optional integer)
 */
int	 esize_int; 	/* elements size must be > 0 INT */
int	 esize_flag;	/* elements size must be > 0 FLAG */

/*
 *  position in the index order for the elements dimension (Optional list)
 */
int	 eindex_list;	/* position in the index order for the elements dimension LIST INDEX */
char	 *eindex_label;	/* position in the index order for the elements dimension LIST LABEL */
int	 eindex_flag;	/* position in the index order for the elements dimension FLAG */

/*
 *  data type (Optional list)
 */
int	 type_list;	/* data type LIST INDEX */
char	 *type_label;	/* data type LIST LABEL */
int	 type_flag;	/* data type FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kasc2mask_get_args PROTO((kform *));
void kasc2mask_usage_additions PROTO((void));
void kasc2mask_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
