 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kasc2loc
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kasc2loc.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Import ASCII Data File to Location Segment
|
|       Purpose: main program for kasc2loc
|
|         Input:
|		char *clui_info->i1_file; {ASCII input data file containing new data segment}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->o_file; {output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->i2_file; {data object input to insert the new segment into}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		int clui_info->so_int; {starting point in ASCII file to start importing at}
|		int clui_info->so_flag; {TRUE if -so specified}
|
|		int clui_info->sf_int; {number of points in ASCII file to skip between reads}
|		int clui_info->sf_flag; {TRUE if -sf specified}
|
|		int clui_info->wsize_int; {width size must be > 0}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int   clui_info->windex_list; {position in the index order for the width dimension}
|		char *clui_info->windex_label;
|		int   clui_info->windex_flag; {TRUE if -windex specified}
|
|		int clui_info->hsize_int; {height size must be > 0}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int   clui_info->hindex_list; {position in the index order for the height dimension}
|		char *clui_info->hindex_label;
|		int   clui_info->hindex_flag; {TRUE if -hindex specified}
|
|		int clui_info->dsize_int; {depth size must be > 0}
|		int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|		int   clui_info->dindex_list; {position in the index order for the depth dimension}
|		char *clui_info->dindex_label;
|		int   clui_info->dindex_flag; {TRUE if -dindex specified}
|
|		int clui_info->nsize_int; {dimension size must be > 0}
|		int clui_info->nsize_flag; {TRUE if -nsize specified}
|
|		int   clui_info->nindex_list; {position in the index order for the dimension}
|		char *clui_info->nindex_label;
|		int   clui_info->nindex_flag; {TRUE if -nindex specified}
|
|		int   clui_info->type_list; {data type}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: John Salas, Steve Kubica
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        int     i, size_vector[4];
        char    *index_strings[4];
        char    *index_order;
        kobject source_viff = KOBJECT_INVALID, destination_object;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kasc2loc_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kasc2loc",
		kasc2loc_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kasc2loc_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /*
         * Instantiate objects.
         */
        if ( clui_info->i2_flag &&
             (source_viff = kdms_open(clui_info->i2_file,
                                         KOBJ_READ)) == NULL) {
           kerror("kasc2loc", "main", "Failed to open VIFF input object");
           kexit(KEXIT_FAILURE);
        }

        if ( (destination_object = kdms_open(clui_info->o_file,
                                             KOBJ_WRITE)) == NULL) {
           kerror("kasc2loc", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }

        if ( clui_info->windex_list == clui_info->hindex_list ||
             clui_info->windex_list == clui_info->dindex_list ||
             clui_info->windex_list == clui_info->nindex_list ||
             clui_info->hindex_list == clui_info->dindex_list ||
             clui_info->hindex_list == clui_info->nindex_list ||
             clui_info->dindex_list == clui_info->nindex_list ) {
           kerror("kasc2loc", "main", "The index order for a dimension \
must be unique.  One of the specified values is the same.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        size_vector[clui_info->windex_list-1] =
		clui_info->wsize_int;
        size_vector[clui_info->hindex_list-1] =
		clui_info->hsize_int;
        size_vector[clui_info->dindex_list-1] =
		clui_info->dsize_int;
        size_vector[clui_info->nindex_list-1] =
		clui_info->nsize_int;

        index_strings[clui_info->windex_list-1] = "width ";
        index_strings[clui_info->hindex_list-1] = "height ";
        index_strings[clui_info->dindex_list-1] = "depth ";
        index_strings[clui_info->nindex_list-1] = "dimension ";

        index_order = NULL;
        for ( i = 0 ; i < 4 ; i++ ) {
           index_order = kstring_cat(index_order, index_strings[i], NULL);
        }

        if ( !lkimportasc(clui_info->i1_file, source_viff,
                             KDMS_SEGMENT_LOCATION, 4, index_order, size_vector,
                             clui_info->type_label,
                             clui_info->so_int,
                             clui_info->sf_int, destination_object) ) {
           kfree(index_order);
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        kfree(index_order);

        /* add history to the output object */
        if (!kpds_set_attribute(destination_object, 
				KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kasc2loc", "main", 
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kasc2loc_usage_additions
| 
|       Purpose: Prints usage additions in kasc2loc_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kasc2loc
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kasc2loc_usage_additions(void)
{
	kfprintf(kstderr, "\tImport ASCII Data File to Location Segment\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kasc2loc_free_args
| 
|       Purpose: Frees CLUI struct allocated in kasc2loc_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kasc2loc
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kasc2loc_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->o_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->windex_label);
	kfree(clui_info->hindex_label);
	kfree(clui_info->dindex_label);
	kfree(clui_info->nindex_label);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
