/*
 * Khoros: $Id$
 */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>             _static_routines()
   >>>>  Public:
   >>>>             public_routines()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kappend.h"


/*-----------------------------------------------------------
|
|  Routine Name: kappend_build_obj_array - add kobject to array
|
|       Purpose: If the input_flag is set, this function opens the 
|		 input object specified input_file name and adds it
|		 to the object array, obj_array.   It also adds the 
|		 file name to the name_array and increments the 
|		 obj_count.
|
|         Input: input_flag - indicates whether an input file is specified
|                input_file - input file name
|                obj_array - array of kobjects
|		 name_array - array of strings for storing object name
|		 obj_count - pointer to the number of objects.
|
|        Output: obj_count - incremented if a kobject has been added to array
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Donna Koechner
|          Date: Dec 28, 1994
| Modifications:
|
------------------------------------------------------------*/

int kappend_build_obj_array(
    int		input_flag,
    char	*input_file,
    kobject 	*obj_array,
    kstring	*name_array,
    int		*obj_count)
{

	if (input_flag)
	{
	   if ((obj_array[*obj_count] = kpds_open_input_object(input_file)) 
			== KOBJECT_INVALID)
	   {
	      kerror("main","kappend", "Cannot open input object %s.",
			input_file);
              return(FALSE);
	  }
	  name_array[*obj_count] = kbasename(input_file, NULL);
	  (*obj_count) ++;
	}
	return(TRUE);
}
