#ifdef __STDC__
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <math.h>
#include <float.h>
#include <limits.h>
#include <sys/utsname.h>
#else
#include <stdio.h>
#include <sys/utsname.h>
#endif

#define NUMPTS 7
#define LENGTH 1024

#define MY_LONG_MIN (-2147483647L-1L)
#define MY_LONG_MAX 2147483647L
#define MY_INT_MIN (-2147483647-1)
#define MY_INT_MAX 2147483647
#define MY_SHRT_MIN (-32768)
#define MY_SHRT_MAX 32767
#define MY_SCHAR_MIN (-128)
#define MY_SCHAR_MAX 127

#define MY_ULONG_MAX 4294967295UL
#define MY_UINT_MAX 4294967295U
#define MY_USHRT_MAX 65535
#define MY_UCHAR_MAX 255

main()
{
   struct utsname info;
   char doublename[LENGTH];
   char floatname[LENGTH];
   char longname[LENGTH];
   char intname[LENGTH];
   char shortname[LENGTH];
   char charname[LENGTH];
   char uintname[LENGTH];
   char ulongname[LENGTH];
   char ushortname[LENGTH];
   char ucharname[LENGTH];
   int f;
   int i;
/*
 * would have liked to use DBL_MIN, DBL_MAX, DBL_EPSILON, but these
 * vary so much that testsuites can't be verified, except by hand.
 */
   double doubledata[] = {0.0, 1.0, 1.234567e-30, -1.234567e+30, 1.234567e+30, 
			  M_PI, M_E};
   float floatdata[] = {0.0, 1.0, 1.234567e-9, -1.234567e15, 1.234567e15, 
			M_PI, M_E};
   
   long  longdata[] = {0, 1, MY_LONG_MIN, MY_LONG_MAX, 100, -1000, 10000};
   int  intdata[] = {0, 1, MY_INT_MIN, MY_INT_MAX, 100, -1000, 10000};
   short  shortdata[] = {0, 1, MY_SHRT_MIN, MY_SHRT_MAX, 100, -1000, 10000};
   char  chardata[] = {0, 1, MY_SCHAR_MIN, MY_SCHAR_MAX, 10, 100, -100};

   unsigned long  ulongdata[] = {0, 1, 0, MY_ULONG_MAX, 100, 1000, 10000};
   unsigned int  uintdata[] = {0, 1, 0, MY_UINT_MAX, 100, 1000, 10000};
   unsigned short  ushortdata[] = {0, 1, 0, MY_USHRT_MAX, 100, 1000, 10000};
   unsigned char  uchardata[] = {0, 1, 0, MY_UCHAR_MAX, 10, 100, 200};
  
   unsigned char *sss = (unsigned char *)shortdata;
 
   for (i = 0; i < 7; i++)
      printf("%d\t%x %x %x %x %x %x %x %x \n",(int)shortdata[i],
	sss[8*i],sss[8*i+1],sss[8*i+2],sss[8*i+3],sss[8*i+4],sss[8*i+5],sss[8*i+6],sss[8*i+7]);      
	sss[2] = 0x40;
   uname(&info);

   sprintf(doublename,"../data/double.%s",info.machine);
   sprintf(floatname,"../data/float.%s",info.machine);
   sprintf(longname,"../data/long.%s",info.machine);
   sprintf(intname,"../data/int.%s",info.machine);
   sprintf(shortname,"../data/short.%s",info.machine);
   sprintf(charname,"../data/char.%s",info.machine);
   sprintf(ulongname,"../data/ulong.%s",info.machine);
   sprintf(uintname,"../data/uint.%s",info.machine);
   sprintf(ushortname,"../data/ushort.%s",info.machine);
   sprintf(ucharname,"../data/uchar.%s",info.machine);
   
   /*
    * do the double case
    */
   f = open(doublename, O_WRONLY|O_CREAT, 0644);
   write(f, doubledata, NUMPTS * sizeof(double));
   close(f);

   /*
    * do the float case
    */
   f = open(floatname, O_WRONLY|O_CREAT, 0644);
   write(f, floatdata, NUMPTS * sizeof(float));
   close(f);
   
   /*
    * do the long case
    */
   f = open(longname, O_WRONLY|O_CREAT, 0644);
   write(f, longdata, NUMPTS * sizeof(long));
   close(f);

   /*
    * do the int case
    */
   f = open(intname, O_WRONLY|O_CREAT, 0644);
   write(f, intdata, NUMPTS * sizeof(int));
   close(f);

   /*
    * do the short case
    */
   f = open(shortname, O_WRONLY|O_CREAT, 0644);
   write(f, shortdata, NUMPTS * sizeof(short));
   close(f);

   /*
    * do the char case
    */
   f = open(charname, O_WRONLY|O_CREAT, 0644);
   write(f, chardata, NUMPTS * sizeof(char));
   close(f);

   /*
    * do the ulong case
    */
   f = open(ulongname, O_WRONLY|O_CREAT, 0644);
   write(f, ulongdata, NUMPTS * sizeof(unsigned long));
   close(f);

   /*
    * do the uint case
    */
   f = open(uintname, O_WRONLY|O_CREAT, 0644);
   write(f, uintdata, NUMPTS * sizeof(unsigned int));
   close(f);

   /*
    * do the ushort case
    */
   f = open(ushortname, O_WRONLY|O_CREAT, 0644);
   write(f, ushortdata, NUMPTS * sizeof(unsigned short));
   close(f);

   /*
    * do the uchar case
    */
   f = open(ucharname, O_WRONLY|O_CREAT, 0644);
   write(f, uchardata, NUMPTS * sizeof(unsigned char));
   close(f);
}
