/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>             Geometry Attribute Actions                <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                 kvf_get_width()                       <<<<
   >>>>                 kvf_set_width()                       <<<<
   >>>>                 kvf_get_height()                      <<<<
   >>>>                 kvf_set_height()                      <<<<
   >>>>                 kvf_get_x()                           <<<<
   >>>>                 kvf_set_x()                           <<<<
   >>>>                 kvf_get_y()                           <<<<
   >>>>                 kvf_set_y()                           <<<<
   >>>>                 kvf_get_buttonwidth()                 <<<<
   >>>>                 kvf_set_buttonwidth()                 <<<<
   >>>>                 kvf_get_buttonheight()                <<<<
   >>>>                 kvf_set_buttonheight()                <<<<
   >>>>                 kvf_get_buttonx()                     <<<<
   >>>>                 kvf_set_buttonx()                     <<<<
   >>>>                 kvf_get_buttony()                     <<<<
   >>>>                 kvf_set_buttony()                     <<<<
   >>>>                 kvf_get_xpos()                        <<<<
   >>>>                 kvf_set_xpos()                        <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"


/*-----------------------------------------------------------
|
|       Routine: kvf_get_width
|       Purpose: Gets the width value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_WIDTH ("kvf_width")
|        Output: calldata  - passes back float width value 
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_width(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	float        *width;
	Line_Info    line_info;

        /* the value to which KVF_WIDTH is to be set */
        width = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	*width = line_info.width;
	kvf_free_line_info_strings(&line_info);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_set_width
|       Purpose: Sets the width value of the geometry
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_WIDTH ("kvf_width")
|                calldata  - provides float width value 
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_width(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *width;
	Line_Info    line_info;

	/* the value to which KVF_WIDTH is to be set */
        width = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	line_info.width = *width;
	kvf_gen_deparse_kformstruct(kformstruct, &line_info);

	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_get_height
|       Purpose: Gets the height value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_HEIGHT ("kvf_height")
|        Output: calldata  - passes back float height value 
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_height(
   kform_struct *kformstruct,
   char     *attribute,
   kaddr    calldata)
{
	float        *height;
	Line_Info    line_info;

        /* set the pointer to be returned */
        height = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	*height = line_info.height;
	kvf_free_line_info_strings(&line_info);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_set_height
|       Purpose: Sets the height value of the geometry
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_HEIGHT ("kvf_height")
|                calldata  - provides float value for height
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_height(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float      *height;
	Line_Info  line_info;

	/* the value to which KVF_HEIGHT is to be set */
        height = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	line_info.height = *height;
	kvf_gen_deparse_kformstruct(kformstruct, &line_info);

	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_get_x
|       Purpose: Gets the x value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_X ("kvf_x")
|        Output: calldata  - passes back float X value 
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_x(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	float        *x;
	Line_Info    line_info;

        /* set the pointer to be returned */
        x = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	*x = line_info.x;
	kvf_free_line_info_strings(&line_info);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_set_x
|       Purpose: Sets the x value of the geometry
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_X ("kvf_x")
|                calldata  - provides float value for x
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_x(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *x;
	Line_Info    line_info;

        /* set the pointer to be returned */
        x = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	line_info.x = *x;
	kvf_gen_deparse_kformstruct(kformstruct, &line_info);

	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_get_y
|       Purpose: Gets the y value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_Y ("kvf_y")
|        Output: calldata  - passes back float Y value 
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_y(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	float        *y;
	Line_Info    line_info;

        /* set the pointer to be returned */
        y = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	*y = line_info.y;
	kvf_free_line_info_strings(&line_info);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_set_y
|       Purpose: Sets the y value of the geometry
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_Y ("kvf_y")
|                calldata  - provides float value for y
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_y(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *y;
	Line_Info    line_info;

	/* the value to which KVF_Y is to be set */
        y = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	line_info.y = *y;
	kvf_gen_deparse_kformstruct(kformstruct, &line_info);

	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_get_xpos
|       Purpose: Gets the xpos value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_XPOS ("kvf_xpos")
|        Output: calldata  - passes back float x position value
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_xpos(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *xpos;
        Line_Info    line_info;

        /* set the pointer to be returned */
        xpos = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

        *xpos = line_info.xpos;
        kvf_free_line_info_strings(&line_info);

        return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_set_xpos
|       Purpose: Sets the x value of the title offset
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_XPOS ("kvf_xpos")
|                calldata  - provides float value for xpos
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_xpos(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *xpos;
	Line_Info    line_info;
	ksubform     *subform;

	/* the value to which KVF_XPOS is to be set */
        xpos = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	line_info.xpos = *xpos;
	kvf_gen_deparse_kformstruct(kformstruct, &line_info);

	/* for titles of subforms, need to move the text */
	if (kformstruct->type == KSUBFORM)
	{
            kvf_clear_line_info(&line_info);
            subform = kformstruct->Subformptr;
            kvf_parse_startsubform_line(subform->control_line, &line_info);
	    line_info.xpos = *xpos;
	    kvf_deparse_startsubform_line(&line_info, &subform->control_line);
        }

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_get_ypos
|       Purpose: Gets the ypos value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_YPOS ("kvf_ypos")
|        Output: calldata  - passes back float y position value
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_ypos(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *ypos;
        Line_Info    line_info;
	ksubform     *subform;

        /* set the pointer to be returned */
        ypos = (float *) calldata;

	if (kformstruct->flag == KUIS_SUBFORMBUTTON) 
	{
	    kvf_clear_line_info(&line_info);
	    subform = kformstruct->Subformptr;
	    kvf_parse_startsubform_line(subform->control_line, &line_info);
	}
	else
	{
	    if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	        return(FALSE);

	}
        *ypos = line_info.ypos;

        kvf_free_line_info_strings(&line_info);
        return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_set_ypos
|       Purpose: Sets the y value of the title offset
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_YPOS ("kvf_ypos")
|                calldata  - provides float value for ypos
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_ypos(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *ypos;
	Line_Info    line_info;
	ksubform     *subform;

	/* the value to which KVF_YPOS is to be set */
        ypos = (float *) calldata;

	if (!(kvf_gen_parse_kformstruct(kformstruct, &line_info)))
	    return(FALSE);

	line_info.ypos = *ypos;
	kvf_gen_deparse_kformstruct(kformstruct, &line_info);

	/* for titles of subforms, need to move the text */
	if (kformstruct->type == KSUBFORM)
	{
            kvf_clear_line_info(&line_info);
            subform = kformstruct->Subformptr;
            kvf_parse_startsubform_line(subform->control_line, &line_info);
	    line_info.ypos = *ypos;
	    kvf_deparse_startsubform_line(&line_info, &subform->control_line);
        }

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_get_buttonwidth
|       Purpose: Gets the value of the width field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to get
|                the width of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls kvf_get_width().
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_BUTTONWIDTH ("kvf_buttonwidth")
|        Output: calldata  - passes back float width value 
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_buttonwidth(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	float        *width;
	Line_Info    line_info;
	char         *line = NULL;

        if (kformstruct->type != KSUBFORM)
            return(kvf_get_width(kformstruct, KVF_WIDTH, calldata));

        /* the value to which KVF_WIDTH is to be set */
        width = (float *) calldata;

        /*
         * Note: we are parsing the UIS line directly here,
         *       because kvf_gen_parse_kformstruct isn't smart
         *       enough to know whether you want the -M or the -d
         *       for a subform.
         */
        kvf_clear_line_info(&line_info);
        line = kformstruct->Subformptr->line;
        if (!(kvf_parse_subformbutton_line(line, &line_info)))
            return(FALSE);
	*width = line_info.width;
	kvf_free_line_info_strings(&line_info);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_set_buttonwidth
|       Purpose: Sets the value of the width field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to set
|                the width of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls kvf_set_width().
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_BUTTONWIDTH ("kvf_buttonwidth")
|                calldata  - provides float width value 
|        Output: none
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_buttonwidth(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *width;
	Line_Info    line_info;
	char         *line = NULL;

        if (kformstruct->type != KSUBFORM)
            return(kvf_set_width(kformstruct, KVF_WIDTH, calldata));

	/* the value to which KVF_WIDTH is to be set */
        width = (float *) calldata;

        /*
         * Note: we are parsing the UIS line directly here,
         *       because kvf_gen_parse_kformstruct isn't smart
         *       enough to know whether you want the -M or the -d
         *       for a subform.
         */
        kvf_clear_line_info(&line_info);
        line = kformstruct->Subformptr->line;
        if (!(kvf_parse_subformbutton_line(line, &line_info)))
            return(FALSE);
	line_info.width = *width;
        kvf_gen_deparse(&line_info, &kformstruct->Subformptr->line);
        kvf_free_line_info_strings(&line_info);
	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_get_buttonheight
|       Purpose: Gets the value of the height field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to get
|                the height of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls kvf_get_height().
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_BUTTONHEIGHT ("kvf_buttonheight")
|        Output: calldata  - passes back float height value 
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_buttonheight(
   kform_struct *kformstruct,
   char     *attribute,
   kaddr    calldata)
{
	float        *height;
	Line_Info    line_info;
	char         *line = NULL;

        if (kformstruct->type != KSUBFORM)
            return(kvf_get_height(kformstruct, KVF_HEIGHT, calldata));

        /* set the pointer to be returned */
        height = (float *) calldata;

        /*
         * Note: we are parsing the UIS line directly here,
         *       because kvf_gen_parse_kformstruct isn't smart
         *       enough to know whether you want the -M or the -d
         *       for a subform.
         */
	kvf_clear_line_info(&line_info);
        line = kformstruct->Subformptr->line;
        if (!(kvf_parse_subformbutton_line(line, &line_info)))
            return(FALSE);
	*height = line_info.height;
	kvf_free_line_info_strings(&line_info);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_set_buttonheight
|       Purpose: Sets the value of the height field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to set
|                the height of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls kvf_set_height().
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_BUTTONHEIGHT ("kvf_buttonheight")
|                calldata  - provides float value for height
|        Output: none
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_buttonheight(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float      *height;
	Line_Info  line_info;
	char       *line = NULL;

        if (kformstruct->type != KSUBFORM)
            return(kvf_set_height(kformstruct, KVF_HEIGHT, calldata));

	/* the value to which KVF_HEIGHT is to be set */
        height = (float *) calldata;

        /*
         * Note: we are parsing the UIS line directly here,
         *       because kvf_gen_parse_kformstruct isn't smart
         *       enough to know whether you want the -M or the -d
         *       for a subform.
         */
        kvf_clear_line_info(&line_info);
        line = kformstruct->Subformptr->line;
        if (!(kvf_parse_subformbutton_line(line, &line_info)))
            return(FALSE);
        line_info.height = *height;
        kvf_gen_deparse(&line_info, &kformstruct->Subformptr->line);
        kvf_free_line_info_strings(&line_info);

	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_get_buttonx
|       Purpose: Gets the value of the x field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to get
|                the x value of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls kvf_get_x().
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_BUTTONX ("kvf_buttonx")
|        Output: calldata  - passes back float X value 
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_buttonx(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	float        *x;
	Line_Info    line_info;
	char         *line = NULL;

        if (kformstruct->type != KSUBFORM)
            return(kvf_get_x(kformstruct, KVF_X, calldata));

        /* set the pointer to be returned */
        x = (float *) calldata;

        /*
         * Note: we are parsing the UIS line directly here,
         *       because kvf_gen_parse_kformstruct isn't smart
         *       enough to know whether you want the -M or the -d
         *       for a subform.
         */
        kvf_clear_line_info(&line_info);
        line = kformstruct->Subformptr->line;
        if (!(kvf_parse_subformbutton_line(line, &line_info)))
            return(FALSE);
	*x = line_info.x;
	kvf_free_line_info_strings(&line_info);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_set_buttonx
|       Purpose: Sets the value of the x field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to set
|                the x value of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls kvf_set_x().
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_BUTTONX ("kvf_buttonx")
|                calldata  - provides float value for x
|        Output: none
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_buttonx(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *x;
	Line_Info    line_info;
	char         *line = NULL;

        if (kformstruct->type != KSUBFORM)
            return(kvf_set_x(kformstruct, KVF_X, calldata));

        /* set the pointer to be returned */
        x = (float *) calldata;

        /*
         * Note: we are parsing the UIS line directly here,
         *       because kvf_gen_parse_kformstruct isn't smart
         *       enough to know whether you want the -M or the -d
         *       for a subform.
         */
        kvf_clear_line_info(&line_info);
        line = kformstruct->Subformptr->line;
        if (!(kvf_parse_subformbutton_line(line, &line_info)))
            return(FALSE);
	line_info.x = *x;
        kvf_gen_deparse(&line_info, &kformstruct->Subformptr->line);
        kvf_free_line_info_strings(&line_info);

	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_get_buttony
|       Purpose: Gets the value of the y field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to get
|                the y value of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls kvf_get_y().
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_BUTTONY ("kvf_buttony")
|        Output: calldata  - passes back float Y value 
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_get_buttony(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	float        *y;
	Line_Info    line_info;
	char         *line = NULL;

        if (kformstruct->type != KSUBFORM)
            return(kvf_get_y(kformstruct, KVF_Y, calldata));

        /* set the pointer to be returned */
        y = (float *) calldata;

        /*
         * Note: we are parsing the UIS line directly here,
         *       because kvf_gen_parse_kformstruct isn't smart
         *       enough to know whether you want the -M or the -d
         *       for a subform.
         */
        kvf_clear_line_info(&line_info);
        line = kformstruct->Subformptr->line;
        if (!(kvf_parse_subformbutton_line(line, &line_info)))
            return(FALSE);
	*y = line_info.y;
	kvf_free_line_info_strings(&line_info);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_set_buttony
|       Purpose: Sets the value of the y field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to set
|                the y value of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls kvf_set_y().
|
|         Input: kformstruct - generic kformstruct holding ptr to GUI item
|                attribute - KVF_BUTTONY ("kvf_buttony")
|                calldata  - provides float value for y
|        Output: none
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int kvf_set_buttony(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float        *y;
	Line_Info    line_info;
	char         *line = NULL;

        if (kformstruct->type != KSUBFORM)
            return(kvf_set_y(kformstruct, KVF_Y, calldata));

	/* the value to which KVF_Y is to be set */
        y = (float *) calldata;

        /*
         * Note: we are parsing the UIS line directly here,
         *       because kvf_gen_parse_kformstruct isn't smart
         *       enough to know whether you want the -M or the -d
         *       for a subform.
         */
        kvf_clear_line_info(&line_info);
        line = kformstruct->Subformptr->line;
        if (!(kvf_parse_subformbutton_line(line, &line_info)))
            return(FALSE);
	line_info.y = *y;
        kvf_gen_deparse(&line_info, &kformstruct->Subformptr->line);
        kvf_free_line_info_strings(&line_info);

	return(TRUE);
}

