/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Global Function and Constant definition
   >>>>		       used by the khoros expression parser.
   >>>>
   >>>>    Written By: & Mark Young
   >>>>
   >>>>          Date: Apr 04, 1994
   >>>>
   >>>> Modifications: 
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kexpr_internals_h_
#define _kexpr_internals_h_

	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <bootstrap.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define Value	    u.value
#define Operator    u.operator
#define Instruction u.instruction
#define Function    u.function
#define String	    u.string

#define	GLOBAL_ID   -1
#define	FUNCTION_ID -2
#define	CONSTANT_ID -3


	/*-------------------------------------*
	|       typdefs
	---------------------------------------*/

/*
 * Function structure declaration
 */
struct _function
{
	char    *name;
	kfunc_double routine;
	int      num_args;
};

/*
 * Constant structure declaration
 */
struct _constant
{
	char *name;
	double value;
};


/*
 *  The following definition is used to define a single token.
 *  Such as the definition of x, or the definition of a function, etc.
 */
typedef struct _symbol
{
	char *name;
	int  type;
	unsigned char eval, num;
	struct _symbol_list *symlist;
	union
	{
	   double value;
	   char   *string;
	   int    operator;
	   int    instruction;
	   double (*function)();
	} u;
} Symbol;

typedef struct _symbol_list
{
	Symbol *symbol;
	struct _symbol_list *next;
} SymbolList;

typedef struct _varlist
{
	long	   id;
	SymbolList *symlist;
	struct _varlist *next, *parent;
} Varlist;


	/*-------------------------------------*
	|      global variable declarations
	---------------------------------------*/


extern int	current_id;
extern Symbol   FinalValue;
extern Symbol   *CompiledSymbol;
extern jmp_buf	jump_dest;
extern int	jump_dest_enabled;
extern int	error_found;
extern char	*sptr, *string_array, *kexpr_error_string;


	/*-------------------------------------*
	|	routine definitions
	---------------------------------------*/
 
    /* build.c */
 
void kexpr_error PROTO((char *));
SymbolList *kexpr_add_number      PROTO((SymbolList *, double));
SymbolList *kexpr_add_operator    PROTO((SymbolList *, int, char *, int ));
SymbolList *kexpr_add_instruction PROTO((SymbolList *, int, char *, int ));
SymbolList *kexpr_add_string      PROTO((SymbolList *, char *));
SymbolList *kexpr_add_symlist     PROTO((SymbolList *, SymbolList *));
SymbolList *kexpr_copy_symlist    PROTO((SymbolList *));
 
    /* constant.c */
 
Symbol *kexpr_get_constant PROTO((char *));
 
    /* eval.c */
 
int kexpr_eval_symbol  PROTO((Symbol *, int, Symbol *));
int kexpr_eval_symlist PROTO((SymbolList *, int, Symbol *));
 
    /* function.c */
 
SymbolList *kexpr_add_function PROTO((SymbolList *, Symbol *, int));
void kexpr_check_function      PROTO((Symbol *, SymbolList *, SymbolList *));
Symbol *kexpr_get_function     PROTO((char *));
 
    /* print.c */
 
void kexpr_print_symbol  PROTO((kfile *, Symbol *, int));
void kexpr_print_symlist PROTO((kfile *, SymbolList *, int));
 
    /* routines.c */
 
    /* utilities.c */
 
Varlist *kexpr_get_varlist PROTO((long));
int kexpr_delete_varlist   PROTO((long));
Symbol *kexpr_get_symbol   PROTO((Varlist *, char *, int));
Symbol *kexpr_add_symbol   PROTO((Varlist *, char *, int, double));
int kexpr_delete_symbol    PROTO((int, Symbol *));
void kexpr_free_symbol     PROTO((Symbol *));
void kexpr_free_symlist    PROTO((SymbolList *));
int kexpr_eval_expression  PROTO((long, char *, char *));
 
    /* variable.c */
 
SymbolList *kexpr_add_variable PROTO((SymbolList *, Symbol *));
void kexpr_check_variable PROTO((Symbol *));
Symbol *kexpr_get_variable PROTO((char *, int));

    /* kexpr_lex.l */
void kexpr_set_value       PROTO((void));
void kexpr_set_string      PROTO((void));

#endif /* _kexpr_internals_h_ */
/* Don't add after this point */
