/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     print utilities for generating GUI information    <<<<
   >>>>     structure initialization code for xvroutines      <<<<
   >>>>                     in form_init.c                    <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>          kgen_gui_print_create_subform_struct()       <<<<
   >>>>          kgen_gui_print_create_pane_struct()          <<<<
   >>>>          kgen_gui_print_create_sel_struct()           <<<<
   >>>>          kgen_uis_type_string()                       <<<<
   >>>>          kgen_gui_init_warning()                      <<<<
   >>>>          kgen_gui_init_error()                        <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"  

/*-- this structure holds the identifier for a UIS item, and its name --*/
typedef struct _UisItem
{
	int	id;
	char	*name;
} UisItem;

/*-- table of all UIS items --*/
static UisItem	uis_item_table[] =
{
	{KUIS_MASTERACTION,	"master action button"},
	{KUIS_SUBFORMBUTTON,	"subform button"},
	{KUIS_SUBFORMACTION,	"subform action button"},
	{KUIS_GUIDEBUTTON,	"guide button"},
	{KUIS_INPUTFILE,	"input selection"},
	{KUIS_OUTPUTFILE,	"output selection"},
	{KUIS_STDIN,	        "kstdin selection"},
	{KUIS_STDOUT,	        "kstdout selection"},
	{KUIS_INTEGER,		"integer selection"},
	{KUIS_FLOAT,		"float selection"},
	{KUIS_DOUBLE,		"double selection"},
	{KUIS_STRING,		"string selection"},
	{KUIS_STRINGLIST,	"string list selection"},
	{KUIS_LOGICAL,		"logical selection"},
	{KUIS_FLAG,		"flag selection"},
	{KUIS_CYCLE,		"cycle selection"},
	{KUIS_LIST,		"list selection"},
	{KUIS_DISPLAYLIST,	"displaylist selection"},
	{KUIS_TOGGLE,		"toggle selection"},
	{KUIS_ROUTINE,		"routine button"},
	{KUIS_PANEACTION,	"pane action button"},
	{KUIS_WORKSPACE,	"workspace"},
	{KUIS_QUIT,		"quit button"},
	{KUIS_BLANK,		"blank selection"}
};

/*--------------------------------------------------------------
|
|  Routine Name: kgen_gui_print_create_subform_struct
|
|       Purpose: prints code to create kform_struct from subform name
|
| 	  Input: file        - open stream to "form_init.c" file
|		 fullname    - full name of GUI item on master form
|		 form_var    - name of the variable on the -F line
|		 subform_var - name of the variable on the -M line
|
|        Output: none
|          Date: May 23, 1992
|    Written By: Danielle Argiro
| Modifications:
|
--------------------------------------------------------------*/
        
void kgen_gui_print_create_subform_struct(
   kfile *file,
   char  *fullname,
   char  *form_var,
   char  *subform_var)
{
	kfprintf(file, "\tforminfo->%s_struct =\n", subform_var);
	kfprintf(file, "\t    kvf_create_struct_from_subformname(form, ");
	kfprintf(file, "\"%s\");\n", fullname);
	kfprintf(file, "\tif (forminfo->%s_struct == NULL)\n\t{\n", subform_var);
	kfprintf(file, "\t    _xvf_init_%s_error(\"subform '%s' on form '%s'\", \n\t\t\t    \"%s_%s\");\n",
                        form_var, subform_var, form_var, form_var, subform_var);
	kfprintf(file, "\t    return(FALSE);\n");
        kfprintf(file, "\t}\n");
}


/*--------------------------------------------------------------
|
|  Routine Name: kgen_gui_print_create_pane_struct
|
|       Purpose: prints code to create kform_struct from pane name
|
|  	  Input: file        - open stream to "form_init.c" file
|		 fullname    - full name of GUI pane
|		 form_var    - name of the variable on the -F line
|		 subform_var - name of the variable on the -M line
|		 variable    - variable name on the -P line 
|
|        Output: none
|          Date: May 23, 1992
|    Written By:  Danielle Argiro
| Modifications:
|
--------------------------------------------------------------*/

void kgen_gui_print_create_pane_struct(
   kfile *file,
   char  *fullname,
   char  *form_var,
   char  *subform_var,
   int   subform_type,
   char  *variable)
{
	if (subform_type == KUIS_SUBFORMBUTTON)
	    kfprintf(file, "\tforminfo->%s->%s_struct =\n", 
		     subform_var, variable);
	kfprintf(file, "\t    kvf_create_struct_from_panename(subform, ");

	kfprintf(file, "\"%s\");\n", fullname);

        if (subform_type == KUIS_SUBFORMBUTTON)
	    kfprintf(file, "\tif (forminfo->%s->%s_struct == NULL)\n\t{\n",
                                subform_var, variable);
	kfprintf(file, "\t    _xvf_init_%s_error(\"pane '%s' on subform '%s'\", \"%s_%s\");\n",
                        form_var, variable, subform_var, subform_var, variable);
	kfprintf(file, "\t    return(FALSE);\n");
        kfprintf(file, "\t}\n");

        if (subform_type == KUIS_SUBFORMBUTTON)
	    kfprintf(file, "\tpane = forminfo->%s->%s_struct->Controlptr;\n",
	        		subform_var, variable);
}

/*--------------------------------------------------------------
|
|  Routine Name: kgen_gui_print_create_sel_struct
|
|       Purpose: prints code to create kform_struct from selection name
|
|	  Input: file         - open stream to "form_init.c" file
|		 fullname     - full name of GUI selection
|                location     - KMASTER, KGUIDEPANE, or KPANE
|		 sel_variable - full variable name for selection 
|        Output: none
|          Date: May 23, 1992
|    Written By:  Danielle Argiro
| Modifications:
|
--------------------------------------------------------------*/

void kgen_gui_print_create_sel_struct(
   kfile *file,
   char  *fullname,
   int   location,
   char  *sel_variable)
{
	char *param2 = NULL;
	
	if (location == KMASTER) 
	    param2 = kstrdup("master->sel_list");
	else if (location == KGUIDEPANE) 
	    param2 = kstrdup("guidepane->sel_list");
	else if (location == KPANE) 
	    param2 = kstrdup("pane->sel_list");

	kfprintf(file, "\t%s_struct =\n", sel_variable);
	kfprintf(file, "\t    kvf_create_struct_from_selname(%s, ", param2);
	kfprintf(file, "\"%s\");\n", fullname);

	kfree(param2);
}


/*--------------------------------------------------------------
|
|  Routine Name: kgen_uis_type_string
|
|       Purpose: Returns string associated with typeflag
|
| 	  Input: flag - typeflag of UIS line defining GUI selection
|        Output: Returns string representing UIS line in english
|          Date: May 23, 1992
|    Written By: Danielle Argiro
| Modifications:
|
--------------------------------------------------------------*/

char *kgen_uis_type_string(
   int flag)
{
	UisItem		*item	= &uis_item_table[0];
	int		count	= sizeof(uis_item_table)/sizeof(UisItem);


	while (count--)
	    if (item->id == flag)
		return kstrdup(item->name);
	    else
		item++;

	return kstrdup("unknown selection");
}

/*--------------------------------------------------------------
|
|  Routine Name: kgen_gui_init_warning
|
|       Purpose: Generates _xvf_init_warning() subroutine in form_init.c
|
| 	  Input: file     - open stream to form_init.c 
|                form_var - variable on -F line
|        Output: none
|          Date: May 12, 1992
|    Written By: Danielle Argiro
| Modifications:
|
--------------------------------------------------------------*/

void kgen_gui_init_warning(
   kfile *file,
   char  *form_var)
{
	char temp[KLENGTH];

        /*
         * generate private header
         */
	ksprintf(temp, "_xvf_init_%s_warning", form_var);
        kgen_privsrc_hdr(file, temp, 
	         "Prints warning when code is out of sync with UIS file",
                 "string - item that cannot be found", "none", 
		 "conductor", " ");
        /*
         * generate _xvf_init_warning routine
         */
	kfprintf(file, "static void _xvf_init_%s_warning(\n",
		 form_var);
	kfprintf(file, "    char *string)\n{\n");

	kfprintf(file, "\tkfprintf(kstderr, \"Warning: cannot find %%s.\\n\", string);\n");
	kfprintf(file, "\tkfprintf(kstderr, \"         UIS file out of sync with code\\n\");\n");
	kfprintf(file, "\tkfprintf(kstderr, \"         generated by conductor in 'form_init.c'.\\n\");\n}\n\n\n");

}

/*--------------------------------------------------------------
|
|  Routine Name: xvf_gen_init_error
|
|       Purpose: Generates _xvf_init_{name}_error() subroutine in form_init.c
|
| 	  Input: file      - open stream to form_init.c 
|                form_var  - name of variable on -F line
|        Output: none
|          Date: May 12, 1992
|    Written By: Danielle Argiro
| Modifications:
|
--------------------------------------------------------------*/

void kgen_gui_init_error(
   kfile *file,
   char  *form_var)
{
	char temp[KLENGTH];

        /*
         * generate private header
         */
	ksprintf(temp, "_xvf_init_%s_error", form_var);

        kgen_privsrc_hdr(file, temp, 
	         "Prints error when code is irreconcilable with UIS file",
                 "string1 - item that cannot be found\n|                string2 - name of FormInfo structure", "none", 
		 "conductor", " ");

        /*
         * generate _xvf_init_error routine
         */
	kfprintf(file, "static void _xvf_init_%s_error(\n",
		 form_var);
	kfprintf(file, "    char *string1,\n");
	kfprintf(file, "    char *string2)\n{\n");

	kfprintf(file, "\tkfprintf(kstderr, \"ERROR: cannot find %%s.\\n\", string1);\n");
	kfprintf(file, "\tkfprintf(kstderr, \"         UIS file out of sync with code\\n\");\n");
	kfprintf(file, "\tkfprintf(kstderr, \"         generated by conductor in 'form_init.c'.\\n\");\n");
	kfprintf(file, "\tkfprintf(kstderr, \"         Unable to initialize '%%s' structure as defined in form_info.h; Aborting.\\n\", string2);\n");
	kfprintf(file, "}\n\n\n");
}

/*--------------------------------------------------------------
|
|  Routine Name: kgen_create_init_srcfile_hdr
|
|       Purpose: Generates the source file header for form_init.c
|
|         Input: file        - open stream of file to write to
|                form_var    - variable off the -F line
|                form        - pointer to the form tree
|        Output: none
|       Returns: none
|          Date: Sep 30, 1992
|    Written By: Danielle Argiro
| Modifications:
|
----------------------------------------------------------------*/
void kgen_create_init_srcfile_hdr(
   kfile *file,
   char  *form_var)
{
	int       i, priv_routine_num = 0;
	char      routine[KLENGTH];
	char      **priv_routines, **stat_routines;

        priv_routine_num = 0;
        priv_routines = (char **) kcalloc(1, 2*sizeof(char *));
        ksprintf(routine, "_xvf_init_%s", form_var);
        priv_routines[priv_routine_num++] = kstrdup(routine);
        ksprintf(routine, "_xvf_free_%s", form_var);
        priv_routines[priv_routine_num++] = kstrdup(routine);

        stat_routines = (char **) kcalloc(1, 2*sizeof(char *));
        ksprintf(routine, "_xvf_init_%s_warning", form_var);
        stat_routines[0] = kstrdup(routine);
        ksprintf(routine, "_xvf_init_%s_error", form_var);
        stat_routines[1] = kstrdup(routine);
        kgen_srcfile_hdr(file, "FormInfo Initialization Routines",
                         priv_routines, priv_routine_num,
                         stat_routines, 2, NULL, 0);

	for (i = 0; i < 2; i++)
	    kfree(stat_routines[i]);

	for (i = 0; i < priv_routine_num; i++)
	    kfree(priv_routines[i]);

	kfree(priv_routines);
        kfree(stat_routines);
}
