/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>        Utilities for generating GUI drivers           <<<<
   >>>>        for xvroutines in form_drv.c                   <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>           kgen_gui_selection_comment()                <<<<
   >>>>           kgen_gui_file_hdr()                         <<<<
   >>>>           kgen_gui_selection_function()               <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"  


/*------------------------------------------------------------
|
|  Routine Name: kgen_gui_selection_comment
|
|       Purpose: Depending on whether a selection is "live", optional,
|                or a button, will print out an appropriate comment
|                in the generated code.
|
|         Input: file         - open stream to "l*.c"
|                seltype      - ascii string rep. selection, ie "input file"
|                flag         - one of KGEN_GUI_LIVE, KGEN_GUI_OPTIONAL, or KGEN_GUI_BUTTON
|                indent       - string with whitespace for indenting
|
|        Output: none
|          Date: May 12, 1992
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
void kgen_gui_selection_comment(
   kfile *file,
   char  *seltype,
   int   flag,
   char  *variable,
   char  *indent)
{
	if (file == NULL) return;

	if (flag == KGEN_GUI_LIVE) 
	{
	    kfprintf(file, "%s/*\n", indent);
	    kfprintf(file, "%s * user selected 'live' %s", indent, seltype);
	    kfprintf(file, " selection '%s'\n", variable);
	    kfprintf(file, "%s */\n", indent);
	}
        else if (flag == KGEN_GUI_OPTIONAL)
        {
            kfprintf(file, "%s/*\n", indent);
	    kfprintf(file, "%s * user wants to use optional %s", 
				indent, seltype);
	    kfprintf(file, " selection '%s'\n", variable);
	    kfprintf(file, "%s */\n", indent);
        }
        else if (flag == KGEN_GUI_BUTTON) 
        {
            kfprintf(file, "%s/*\n", indent);
	    kfprintf(file, "%s * user clicked on %s", indent, seltype);
	    kfprintf(file, " selection '%s'\n", variable);
	    kfprintf(file, "%s */\n", indent);
        }
}

/*------------------------------------------------------------
|
|  Routine Name: kgen_gui_file_hdr
|
|       Purpose: Generates a tmp file containing source file header
|                for a file generated by conductor.
|
|         Input: filename      - program_name of file to be created
|                object        - the software object we are generating for.
|                remark        - remark for source file header
|                priv_routines - array of private routines collected
|                                earlier during creation of subform and
|                                pane drivers
|                priv_num      - size of priv_routines[] array.
|        Output: TRUE if file could be generated correctly
|          Date: Nov 24, 1992
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
int kgen_gui_file_hdr(
   char    *filename,
   kobject object,
   char    *remark,
   char    **priv_routines,
   int     priv_num)
{
        kfile    *file;
	kobject  toolbox;
	kstring  oname;
	char     *copyright;


	/*-- get the toolbox containing object, and object name --*/
	if (!kcms_get_attributes(object,
				 KCMS_PARENT, &toolbox,
				 KCMS_NAME,   &oname,
				 KCMS_END))
	   return FALSE;

	/*
         * create & open the file which will have the file header.
         * (doing it here 'cause we don't have names of all the 
         * routines until the end)
         */
        if ((file = kfopen(filename, "w"))== NULL)
        {
	    kerror(KCODEGEN, "kgen_gui_driver", 
		   "Could not create tmp file '%s'", filename);
            return(FALSE);
        }

	/*
         * include the RSC header & copyright.
	 */
	kgen_rcs_chdr(file);
	copyright = kcms_get_copyright(toolbox, KCMS_TB_COPYRIGHT_LONG,
				       KCMS_LANG_C);
        if (copyright != NULL)
            kfprintf(file, "%s\n", copyright);
        kfree(copyright);

	kgen_srcfile_hdr(file, remark, priv_routines, priv_num, 
			 NULL, 0, NULL, 0);

	kfprintf(file, "#include \"%s.h\"\n\n", oname);

        kfclose(file);
	return(TRUE);
}

/*------------------------------------------------------------
|
|  Routine Name: kgen_gui_selection_function
|
|       Purpose: Generates a function associated with the selection.
|
|         Input: file         - file being written to
|                selection    - selection assoc. w/ function
|                location     - location of selection 
|                               (KMASTER, KSUBFORM, or KPANE)
|                info_type    - declared type of Information structure
|                control_var  - program_name of the variable on the -F, -M, or -P line
|                variable     - variable program_name for selection
|
|        Output: func_routines - array of function program_names being collected
|                func_num      - size of func_routines[] array.
|
|          Date: Nov 24, 1992
|    Written By: Danielle Argiro
| Modifications:
|
---------------------------------------------------------------*/

void kgen_gui_selection_function(
   kfile      *file,
   kselection *selection,
   int        location,
   char       *info_type,
   char       *control_var,
   char       *variable,
   char       ***func_routines,
   int        *func_num,
   int        dblclick,
   int        gen_debug)
{
	char *type_string, *info_var;
	char description[KLENGTH];  
	char explanation[KLENGTH]; 
	char routine_program_name[KLENGTH];

	if (file == NULL) return;

	if (location == KMASTER)
            info_var = "master";
        else info_var = control_var;

	if (!dblclick)
	    ksprintf(routine_program_name, "%s_%s", control_var, variable);
	else ksprintf(routine_program_name, "%s_%s_dblclick", 
		      control_var, variable);

	*func_routines = (char **) krealloc(*func_routines,(*func_num+1)
                                                    *sizeof(char *));
	(*func_routines)[*func_num] = kstrdup(routine_program_name);
	(*func_num)++;
	
	if (file == NULL)
	   return;

	if (location == KPANE)
	{
	    ksprintf(explanation, 
		    "%s_info - ptr to PaneInfo struct for %s pane", 
		    info_var, control_var);
	}
	else if (location == KSUBFORM)
	{
	    ksprintf(explanation, 
		    "%s_info - ptr to SubformInfo struct for %s subform", 
		    info_var, control_var);
	}
	else if (location == KMASTER)
	{
	    ksprintf(explanation, "%s_info - ptr to FormInfo struct for %s", 
		     info_var, control_var);
	}

	type_string = kgen_uis_type_string(selection->type);
	if (!dblclick)
	    ksprintf(description, "Do routine which is called when\n|                  %s %s is used", type_string, variable);
	else ksprintf(description, "Do routine which is called when\n|                 user double-clicks on %s item", variable);

	kfree(type_string);

	kgen_privsrc_hdr(file, routine_program_name, description, explanation, 
		         "None", NULL, NULL);
	
	kfprintf(file, "/* ARGSUSED */\n");
	kfprintf(file, "void %s(\n", routine_program_name, control_var);
	kfprintf(file, "     %s *%s_info)\n{\n", info_type, info_var);

	kfprintf(file, "\t/* PUT YOUR CODE HERE ! */\n");

	if (gen_debug) 
	    kgen_gui_selection_debug(file, selection, info_var, "\t");

	kfprintf(file, "}\n\n\n");
}

