/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Public Routines for kcodegen
   >>>> 
   >>>>	Private: 
   >>>>	Static: 
   >>>>	Public: 
   >>>>            kgen_generate_clui
   >>>>            kgen_interpret_clui_selections
   >>>>            kgen_att2ghost
   >>>>            kgen_ghost2att
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

/************************************************************
*
*  Routine Name: kgen_generate_object - generate code for software object
*       Purpose: This function generates everything appropriate for the
*		given object.
*
*         Input: object	- software object (xvroutine) for which to 
*                         generate code 
*
*        Output:
*       Returns: TRUE on success, FALSE otherwise
*    Written By: Neil Bowers
*          Date: July 14, 1994
*************************************************************/
int
kgen_generate_object(
   kobject object)
{
   kobject        file_object;
   int            object_type;		/* software object type */
   unsigned long  update;
   kstring        datestamp;		/*-- time of generation */
   int            result = TRUE;


   if (!kcms_get_attributes(object,
			     KCMS_CMOBJ_TYPE,      &object_type,
			     KCMS_CMOBJ_UIS_FORM,  &file_object,
			     KCMS_CMOBJ_UPDATE_DB, &update,
			     KCMS_END))
   {
      return FALSE;
   }

   /*
    * generate all the files we can, some types don't generate
    * any.. 
    */
   if (!kgen_generate_clui(object))
   {
      kerror(KCODEGEN, "Generate CLUI",
	     "New files have NOT been generated\n");
      result = FALSE;
   }

   /*
    * if the object is an xvroutine, and it has a form UIS file
    * then generate the GUI driver code.
    */
   else if ((object_type == KCMS_XVROUTINE) && (file_object != NULL))
      result = kgen_generate_gui(object);

   if (result && (update & KCMS_UPDATE_REGEN_CODE) == KCMS_UPDATE_REGEN_CODE)
   {
      update ^= KCMS_UPDATE_REGEN_CODE;
      datestamp = kcms_get_date();
      (void)kcms_set_attributes(object,
				KCMS_CMOBJ_UPDATE_DB, update,
				KCMS_DATE,            NULL, NULL, datestamp,
				KCMS_END);
      kfree(datestamp);
   }

   return result;
}

/************************************************************
*  Routine Name: kgen_interpret_clui_selections - interpret pane arguments
*                                           for online help for software object
*
*       Purpose: Given a software object, interprets the selections in
*                the *.pane file, and prints an explanation of each selection
*                to the file given.  This is used only by "kman -hlp", for use
*                with online help accessed via the GUI of software objects.
*
*         Input: file   - file to which to print usage 
*                form   - the form tree associated with 
*                         the program objects's *.pane file
*        Output: 
*       Returns: TRUE if successful, FALSE otherwise.
*    Written By: Danielle Argiro 
*          Date: May 16, 1994
*************************************************************/
int
kgen_interpret_clui_selections(
   kfile      *file, 
   kform      *form)
{
	/*
	 *  sanity check
	 */
	if (form == NULL)
	{
	    kerror(KCODEGEN, "kgen_interpret_clui_pane",
		   "Can't interpret selections on NULL pane!");
	    return(FALSE);
	}

	/*
	 *  get information off the pane: set global variables such as
         *  kgen_req_sel, kgen_opt_sels printing usage.
	 */
        if (!(kgen_clui_get_pane_info(form)))
        {
            kerror(KCODEGEN, "kgen_interpret_clui_selections", 
		  "Unable to obtain UIS information from *.pane form tree\n");
            kexit(KEXIT_FAILURE);
        }

	/*
	 * kgen_clui_print_selections() does the real work of printing the
         * explanation of the selections on the pane for the software object
	 */
        kgen_clui_print_selections(file);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_att2ghost - convert kcms attribute to prog spec const
|
|       Purpose: This routine converts the kcms attribute value to its
|                equivalent prog spec ghost constant
|
|         Input: attribute - attribute to convert
|        Output:
|       Returns: prog spec constant on success, -1 on failure
|  Restrictions:
|    Written By: Steven Jorgensen
|          Date: Feb 24, 1994
| Modifications:
|
------------------------------------------------------------*/
int
kgen_att2ghost(
   int gval)
{
   if (gval < KCMS_CMOBJ_PROG_AUTHORS || gval > KCMS_CMOBJ_PROG_MAN3MANUAL)
      return(-1);
   return(gval - KCMS_CMOBJ_PROG_AUTHORS);
}
 
/*-----------------------------------------------------------
|
|  Routine Name: kgen_ghost2att - convert proc spec const to attribute
|
|       Purpose: This routine converts the prog spec ghost constant to
|                its equivalent kcms attribute value.
|
|         Input: gval - ghostwriter prog spec value
|        Output:
|       Returns: KCMS attribute value on success, -1 on failure
|  Restrictions:
|    Written By: Steven Jorgensen
|          Date: Feb 24, 1994
| Modifications:
|
------------------------------------------------------------*/
int
kgen_ghost2att(
   int gval)
{
   if (gval < AUTHORS || gval > MAN3_MANUAL)
      return(-1);
   return(gval + KCMS_CMOBJ_PROG_AUTHORS);
}
