/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>         Routines to generate %s_free_args() routine   <<<<
   >>>>         to free the CLUI Info structure               <<<<
   >>>>                                                       <<<<
   >>>>   Private:                                            <<<<
   >>>>                kgen_clui_prinT_free_args()            <<<<
   >>>>                                                       <<<<
   >>>>    Static:                                            <<<<
   >>>>                print_free_args()                      <<<<
   >>>>    Public:                                            <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


static void print_free_args        PROTO((kfile *, kselection *));

/*----------------------------------------------------------
|
|       Routine: kgen_clui_print_free_args
|
|       Purpose: This routine prints the free_args() routine in file *.c
|
|         Input: object    - The software object being generated.
|		 file      - An open stream to .c file
|		 prog_spec - The prog_spec array for the object being
|			     generated.
|        Output: none
|
|    Written By: Danielle Argiro
|          Date: Oct 5, 1993
| Modifications:
|
------------------------------------------------------------*/

void kgen_clui_print_free_args(
   kobject   object,
   kfile    *file,
   char    **prog_spec)
{
	int        indx;
	int        object_type;
	kstring    oname;
        char       temp[KLENGTH];
	char       purpose[KLENGTH]; 
	char       routine_name[KLENGTH];
	kobject    form_file = NULL;


	if (!kcms_get_attributes(object,
				 KCMS_NAME,           &oname,
				 KCMS_CMOBJ_TYPE,     &object_type,
				 KCMS_CMOBJ_UIS_FORM, &form_file,
				 KCMS_END))
	   return;

        ksprintf(routine_name, "%s_free_args", oname);
        ksprintf(purpose, "Frees CLUI struct allocated in %s_get_args()",
		 oname);
        ksprintf(temp, "ghostwriter -oname %s", oname);
        kgen_privsrc_hdr(file, routine_name, purpose,
                         "None", "None", temp, NULL);

	/* add ARGSUSED comment: suppresses lint warning about unused args */
        kfprintf(file, "/* ARGSUSED */\n");

	/* free_args routine definition */
        kfprintf(file,
		 "void\n%s_free_args(\n"
		 "    int   status,\n"
		 "    kaddr client_data)\n"
		 "{\n", oname);

	if (kgen_arg_total > 0
	    || (object_type == KCMS_XVROUTINE && form_file == NULL))
	{
	   /* free memory assoc w/ required args */
	   kfprintf(file, "\n\t/* do the wild and free thing */\n");

	   kfprintf(file,
		    "\tif (clui_info != NULL)\n"
		    "\t	{\n");

	   /* free memory assoc w/ required args */
	   indx = 0;
	   while (indx < kgen_req_num)
	      print_free_args(file, kgen_req_sels[indx++]);

	   if (object_type == KCMS_XVROUTINE && form_file != NULL) 
	      kfprintf(file, "\t\tkfree(clui_info->form_file);\n");

	   /* free memory assoc w/ optional args */
	   indx = 0;
	   while (indx < kgen_opt_num)
	      print_free_args(file, kgen_opt_sels[indx++]);

	   /* free memory assoc w/ program itself */
	   kfprintf(file,
		    "\t\tkfree(clui_info);\n"
		    "\t	}\n\n");
	}

	kfprintf(file, "/* -free_handler_additions */\n");
	if (prog_spec[FREEHANDADD] != NULL)
	    kfprintf(file, "%s", prog_spec[FREEHANDADD]);
	kfprintf(file, "/* -free_handler_additions_end */\n");

	kfprintf(file, "}\n");
}

/*----------------------------------------------------------
|
|       Routine: print_free_args
|
|       Purpose: This routine prints the statements to free
|                strings associated with optional & required
|                arguments in the CLUI info structure.
|
|         Input: file      - open stream to .c file
|                selection - selection corresponding to argument
|        Output: none
|
|    Written By: Danielle Argiro
|          Date: Oct 5, 1993
| Modifications:
|
------------------------------------------------------------*/

static void print_free_args(
    kfile       *file,
    kselection  *selection)
{
	int  toggle_type;
	char *variable;

	variable = ktoken_to_string(selection->var_token);
	switch(selection->type)
	{
	    case KUIS_INPUTFILE:
	    case KUIS_OUTPUTFILE:
		 kfprintf(file, "\tkfree(clui_info->%s_file);\n",
		          variable);
                 break;
	    
	    case KUIS_STRING:
	    case KUIS_STRINGLIST:
		 kfprintf(file, "\tkfree(clui_info->%s_string);\n",
		          variable);
                 break;
	    
	    case KUIS_LIST:
	    case KUIS_CYCLE:
	    case KUIS_DISPLAYLIST:
		 kfprintf(file, "\tkfree(clui_info->%s_label);\n",
                          variable);
		 break;

	    case KUIS_TOGGLE:
		 kvf_get_attribute(selection->back_kformstruct,
				   KVF_TOGGLE_TYPE, &toggle_type);

		 if ((toggle_type == KUIS_INPUTFILE)  ||
                     (toggle_type == KUIS_OUTPUTFILE) ||
                     (toggle_type == KUIS_STRING))
            	     kfprintf(file, "\tkfree(clui_info->%s_toggle);\n",
                              variable);
		 break;

	    case KUIS_MUTEXCL:
	    case KUIS_MUTINCL:
	    case KUIS_GROUP:
		 print_free_args(file, selection->group_next);
		 break;

	    default:
		 break;
	}

}
