 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            SunRPC Transport Drivers
   >>>>
   >>>>  Private:
   >>>>			sunrpc_connect
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "phantomd.h"


#if !defined(KSUNRPC_DEF)
RemoteTransport sunrpc_remotetrans[] = {NULL};
#else

/* sunrpc (remote procedure call) transport */
#include <rpc/rpc.h>

static int sunrpc_connect      PROTO((kfile *, char *));

RemoteTransport sunrpc_remotetrans[] =
{
    {
	"Remote Procedure Call (Sun)",
	"sunrpc",
	FALSE,
	sunrpc_connect,
    }
};

/*
 *  Internal resource structures for "Standard SunRPC (AF_UNIX)" transport
 */
typedef struct
{
	int	sunrpc;
} ResourceStruct;



/*-------------------------------------------------------------------*
|  
|		  SunRPC Routines
|  
--------------------------------------------------------------------*/

/*-------------------------------------------------------------
|  
|  Routine Name: sunrpc_connect
|  
|       Purpose: This function opens a "sunrpc" connection.  It is an
|	         internal driver to open a sunrpc, which is called by
|	         the the internal sunrpc routines such as sunrpc_open().
|  
|		  	"sunrpc=XXXXXXXXXX"
|  
|  
|         Input:  file - the kfile structure describing the transport
|		  path - the sunrpc path
|          
|        Output:  returns -1 or the sunrpc id
|  
|   Called From:  internal routine called from kopen()
|  
|    Written By:  Mark Young
|          Date:  Jul 08, 1992 16:06
|  
-------------------------------------------------------------*/

/*ARGSUSED*/
static int sunrpc_connect(
   kfile *file,
   char  *path)
{
	return(-1);
}

#endif  /* KSUNRPC_DEF */
/* don`t add after the endif */
