 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgentb.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgentb_get_args
| 
|       Purpose: Gets command line args for kgentb
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgentb
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgentb_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgentb is out of sync with arguments specified in kgentb's *.pane file; please rerun ghostwriter on kgentb.";


	/*
	 * allocate the kgentb structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kgentb_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "path",
			  &(clui_info->path_string),
			  &(clui_info->path_flag))))
	{
	    kerror(NULL, "kgentb_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "author",
			  &(clui_info->author_string),
			  &(clui_info->author_flag))))
	{
	    kerror(NULL, "kgentb_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "title",
			  &(clui_info->title_string),
			  &(clui_info->title_flag))))
	{
	    kerror(NULL, "kgentb_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "info",
			  &(clui_info->info_string),
			  &(clui_info->info_flag))))
	{
	    kerror(NULL, "kgentb_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "add",
			  &(clui_info->add_flag))))
	{
	    kerror(NULL, "kgentb_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



