 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgenobj
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgenobj.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate a software object from scratch.
|
|       Purpose: main program for kgenobj
|
|         Input:
|		char *clui_info->tb_string; {toolbox name}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {object name}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		char *clui_info->type_toggle; {type of object}
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|		char *clui_info->description_string; {short description of object}
|		int   clui_info->description_flag; {TRUE if -description specified}
|
|		char *clui_info->temp_obj_string; {An object to use as a template}
|		int   clui_info->temp_obj_flag; {TRUE if -temp_obj specified}
|
|		char *clui_info->temp_tb_string; {Toolbox Template Object is in.  If not specified, it assumes the toolbox for the new object}
|		int   clui_info->temp_tb_flag; {TRUE if -temp_tb specified}
|
|		char *clui_info->bname_string; {binary name}
|		int   clui_info->bname_flag; {TRUE if -bname specified}
|
|		int clui_info->form_flag; {TRUE if -form specified}
|
|		char *clui_info->lang_toggle; {Alternate programming language}
|		int   clui_info->lang_flag; {TRUE if -lang specified}
|
|		M.I. group:
|		    int clui_info->pane_flag; {TRUE if -pane specified}
|
|		    int clui_info->cantata_logic; {Will this object be available from Cantata?}
|		    int clui_info->cantata_flag; {TRUE if -cantata specified}
|
|		    char *clui_info->cat_string; {category name}
|		    int   clui_info->cat_flag; {TRUE if -cat specified}
|
|		    char *clui_info->subcat_string; {subcategory name}
|		    int   clui_info->subcat_flag; {TRUE if -subcat specified}
|
|		M.I. group:
|		    int clui_info->lib_flag; {TRUE if -lib specified}
|
|		    char *clui_info->lname_string; {library object to associate l*.c with}
|		    int   clui_info->lname_flag; {TRUE if -lname specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
   kobject  toolbox        = NULL;
   kobject  cmobj          = NULL;
   kobject  template_cmobj = NULL;
   kobject  template_tb    = NULL;
   int	    otype = 0;
   int      ltype;
   int      form;
   int      paneflg;
   int      ci;
   int      itmp;
   kstring  oname;
   kstring  bname;
   kstring  cat;
   kstring  subcat;
   kstring  description;
   kstring  liboname;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(kgenobj_free_args, NULL);

/* -main_get_args_call */
   pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "kgenobj",
			  kgenobj_usage_additions);

   if (!(kclui_check_args()))
      kexit(KEXIT_FAILURE);
   kgenobj_get_args(pane);
   kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
   if ((toolbox = kcms_open_toolbox(clui_info->tb_string)) == NULL)
      kexit(do_exit_junk(template_cmobj, template_tb, cmobj, toolbox,
			 "Cannot open toolbox '%s'", clui_info->tb_string));
   if((cmobj = kcms_open_cmobj(toolbox, clui_info->oname_string)) !=NULL)
   {
      kerror(NULL, "main()",
	     "Object '%s' already exists in the toolbox '%s'",
	     clui_info->tb_string, clui_info->oname_string);
      kcms_close(cmobj);
      kcms_close(toolbox);
      kexit(KEXIT_FAILURE);
   }
   oname = clui_info->oname_string;
   otype = kcms_attr_string2int(KCMS_CMOBJ_TYPE, clui_info->type_toggle);
   if ((clui_info->temp_tb_flag) && (kstrcmp(clui_info->temp_tb_string,
					     clui_info->tb_string) != 0) &&
       ((template_tb = kcms_open_toolbox(clui_info->temp_tb_string))
	== NULL))
      kexit(do_exit_junk(template_cmobj, template_tb, cmobj, toolbox,
			 "Cannot open template toolbox '%s'",
			 clui_info->temp_tb_string));
   else if (template_tb == NULL)
      template_tb = toolbox;
   if (clui_info->temp_obj_flag &&
       (template_cmobj = kcms_open_cmobj(template_tb,
					 clui_info->temp_obj_string)) == NULL)
      kexit(do_exit_junk(template_cmobj, template_tb, cmobj, toolbox,
			 "Cannot open template object '%s'",
			 clui_info->temp_obj_string));
   if (template_cmobj)
   {
      if ( !kcms_get_attribute(template_cmobj, KCMS_CMOBJ_PROGTYPE, &itmp))
	 kexit(do_exit_junk(template_cmobj, template_tb, cmobj,
			    toolbox, "Cannot get template object type"));
      if (itmp != otype)
      {
	 kerror(NULL, "main()",
		"Template object type and specified type are not the same");
	 kcms_close(template_cmobj);
	 if (template_tb != toolbox)
	    kcms_close(template_tb);
	 kcms_close(toolbox);
	 kexit(KEXIT_FAILURE);
      }
   }
   bname = (clui_info->bname_flag ? clui_info->bname_string : NULL);
   cat = (clui_info->cat_flag ? clui_info->cat_string : NULL);
   subcat = (clui_info->subcat_flag ? clui_info->subcat_string : NULL);
   description = (clui_info->description_flag
		  ? clui_info->description_string
		  : "no short description specified");
   liboname = (clui_info->lib_flag ? clui_info->lname_string : NULL);
   form = clui_info->form_flag;
   paneflg = clui_info->pane_flag;
   ltype = (clui_info->lang_flag
	    ? kcms_attr_string2int(KCMS_CMOBJ_LANGTYPE, clui_info->lang_toggle)
	    : KCMS_LANG_NONE);
   ci = (paneflg ? FALSE : clui_info->cantata_logic);
/* -main_before_lib_call_end */

/* -main_library_call */
   cmobj = kcms_generate_cmobj(toolbox, oname, otype, bname, cat, subcat,
			       description,
			       liboname, ltype, form, paneflg, ci,
			       template_cmobj);
   if (cmobj == NULL)
      kexit(do_exit_junk(template_cmobj, template_tb, cmobj, toolbox, NULL));

   kgen_generate_object(cmobj);
/* -main_library_call_end */

/* -main_after_lib_call */
   kcms_close(cmobj);
   kcms_close(toolbox);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgenobj_usage_additions
| 
|       Purpose: Prints usage additions in kgenobj_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenobj
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenobj_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate a software object from scratch.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgenobj_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgenobj_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenobj
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgenobj_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
	kfree(clui_info->type_toggle);
	kfree(clui_info->description_string);
	kfree(clui_info->temp_obj_string);
	kfree(clui_info->temp_tb_string);
	kfree(clui_info->bname_string);
	kfree(clui_info->lang_toggle);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
