 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgenmanual.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgenmanual_get_args
| 
|       Purpose: Gets command line args for kgenmanual
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenmanual
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenmanual_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgenmanual is out of sync with arguments specified in kgenmanual's *.pane file; please rerun ghostwriter on kgenmanual.";


	/*
	 * allocate the kgenmanual structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kgenmanual_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kgenmanual_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kgenmanual_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



