 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Generate Imakefile
   >>>>
   >>>>   Static:
   >>>>             update_field()
   >>>>             update_imakefile()
   >>>>             generate_template()
   >>>>  Private:
   >>>>             generate_imakefile()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kgenimake.h"

static char *unsharedobjs = NULL;

/*-----------------------------------------------------------
|  Routine Name: update_field - update a field within an imakefile
|
|       Purpose: This routine does the actual work of updating a
|		 field within an Imakefile.
|
|         Input: toolbox - the toolbox in which the object will be updated
|		 object  - the object in which we will update the imakefile
|		 type      - whether this is a directory rather than cms object
|		 field     - the field being updated
|		 imakefile - the actual imakefile list
|		 empty     - empty imakefile flag
|		 entry     - the entry within the imakefile list
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Sep 10, 1993
------------------------------------------------------------*/

static int update_field(
   kobject toolbox,
   kobject object,
   int     type,
   char    *directory,
   char    *field,
   char    **imakefile,
   int	   *empty,
   int     entry)
{
	int  obj_flag  = FALSE;
	int  mode = KFILE | KLINK;
	int  i, num, langtype, progtype;
	char *ccfilter = NULL, *filter = NULL, **list, **cclist, *tmp,
	     dir[KLENGTH], temp[KLENGTH], line[100*KLENGTH];

	/* delete me kludge */
	char *topsrc = NULL, *kcms_key = NULL, dbline[100*KLENGTH];


	/*
	 *  Could be a directory imakefile.  If so then check to see if
	 *  we are updating the directory field.  If not and we are a
	 *  directory imakefile then return.
	 */
	if (kstrcmp(field, DIRS) == 0)
	{
	   filter = NULL;
	   mode = KDIR | KLINK;
	}

	/*
	 *  Looks for other cms object type fields...
	 */
	else if (kstrcmp(field, SCRIPTS) == 0)
	{
	   if (object == NULL)
	   {
	      filter = ".*\\.(csh|pl|sh|ksh)$";
	      langtype = KCMS_NOLANG;
	   }
	   else
	   {
	      kcms_get_attribute(object, KCMS_CMOBJ_LANGTYPE, &langtype);

	      if (langtype == KCMS_CSH)
	         filter = ".*\\.csh$";
	      else if (langtype == KCMS_SH)
	         filter = ".*\\.sh$";
	      else if (langtype == KCMS_KSH)
	         filter = ".*\\.ksh$";
	      else if (langtype == KCMS_PERL)
	         filter = ".*\\.pl$";
	      else if (langtype == KCMS_NOLANG)
	      {
	         kcms_get_attribute(object, KCMS_CMOBJ_PROGTYPE, &progtype);
	         if (progtype == KCMS_PANE)
		    filter = ".*\\.sh";
	      }
	   }
	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_SCRIPTS;
	}
	else if (kstrcmp(field, OBJS) == 0)
	{
	   obj_flag = TRUE;
	   filter = ".*\\.[fclyC]$";
	   ccfilter = ".*\\.cc$";
	}
	else if (kstrcmp(field, FOBJS) == 0)
	{
	   obj_flag = TRUE;
	   filter = ".*\\.f$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_FOBJS;
	}
	else if (kstrcmp(field, COBJS) == 0)
	{
	   obj_flag = TRUE;
	   filter = ".*\\.c$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_COBJS;
	}
	else if (kstrcmp(field, CPLUSOBJS) == 0)
	{
	   obj_flag = TRUE;
	   filter = ".*\\.C$";
	   ccfilter = ".*\\.cc$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_CPLUSOBJS;
	}
	else if (kstrcmp(field, LOBJS) == 0)
	{
	   obj_flag = TRUE;
	   filter = ".*\\.l$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_LOBJS;
	}
	else if (kstrcmp(field, YOBJS) == 0)
	{
	   obj_flag = TRUE;
	   filter = ".*\\.y$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_YOBJS;
	}
	else if (kstrcmp(field, HEADER) == 0)
	{
	   filter = ".*\\.h$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_HEADERS;
	}
	else if (kstrcmp(field, SRCS) == 0 ||
		 kstrcmp(field, CSRCS) == 0)
	{
	   filter = ".*\\.c$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_SRCS;
	}
	else if (kstrcmp(field, CPLUSPLUS) == 0)
	{
	   filter = ".*\\.[C]$";
	   ccfilter = ".*\\.cc$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_CPLUSPLUS;
	}
	else if (kstrcmp(field, FSRCS) == 0)
	{
	   filter = ".*\\.f$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_FSRCS;
	}
	else if (kstrcmp(field, LSRCS) == 0)
	{
	   filter = ".*\\.l$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_LSRCS;
	}
	else if (kstrcmp(field, YSRCS) == 0)
	{
	   filter = ".*\\.y$";

	   /* delete me kludge */
	   kcms_key = KCMS_KEY_CMOBJ_YSRCS;
	}
	else if (kstrcmp(field, MANFILE) == 0)
	{
	   filter = ".*\\.man$";
	}
	else if (kstrcmp(field, SECFILE) == 0)
	{
	   filter = ".*\\.sec$";
	}
	else
	{
	   char *info = NULL;

	   if (kstrcmp(field, BINARY_NAME) == 0 && object != NULL)
	   {
	      if (!kcms_get_attribute(object, KCMS_CMOBJ_BNAME, &info) || !info)
		 kcms_get_attribute(object, KCMS_CMOBJ_ONAME, &info);
	   }
	   else if (kstrcmp(field, OBJECT_NAME) == 0 && object != NULL)
	   {
	      kcms_get_attribute(object, KCMS_CMOBJ_ONAME, &info);
	   }
	   else if (kstrcmp(field, TOOLBOX_NAME) == 0 && toolbox != NULL)
	   {
	      kcms_get_attribute(toolbox, KCMS_TB_NAME, &info);
	      info = kstring_lower(info, temp);
	   }
	   else if (kstrcmp(field, LANGTYPE) == 0 && object != NULL)
	   {
	      kcms_get_attribute(object, KCMS_CMOBJ_LANGTYPE, &langtype);
	      info = kcms_attr_int2string(KCMS_CMOBJ_LANGTYPE, langtype);
	   }
	   else if (kstrcmp(field, "CHAPTER_NAME") == 0)
	   {
	      kstring  bname = NULL;

	      if (kcms_get_imake_symbols(NULL, NULL, &bname, NULL)
		  && bname != NULL)
	      {
		 kstrcpy(temp, bname);
		 kfree(bname);
	      }
	      else
		 kbasename(kgetcwd(dir, KLENGTH), temp);

	      info = temp;
	   }
	   else
	      return(TRUE);

	   ksprintf(line, "%s = %s", field, info);
	   kfree(imakefile[entry]);
	   imakefile[entry] = kstring_copy(line, NULL);
	   return(TRUE);
	}

	/*
	 *  Update the list according to the filter and list mode set from
	 *  above...
	 */
	list = karray_dirlist(directory, NULL, filter, mode, FALSE, &num);
	if (ccfilter != NULL)
	{
	   cclist = karray_dirlist(directory, NULL, ccfilter, mode, FALSE, &i);
	   if (cclist != NULL)
	   {
	      list = karray_merge(list, cclist, num, i, FALSE);
	      num += i;
	   }
	}
	ksprintf(line, "%s =", field);
	if (!object) kcms_key = NULL;

	/*
	 *  Need to have library first...
	 */
	if (type == KCMS_DIR)
	{
	   for (i = 0; i < num; i++)
	   {
	      if (kstrcmp(list[i], "library") == 0)
	      {
		 kaddr identifier = list[i];

		 list = karray_delete(list, identifier,num);
		 list = karray_insert(list, identifier,num-1, KLIST_HEAD, TRUE);
		 break;
	      }
	   }
	}

	/* delete me kludge */
	if (kcms_key != NULL)
	{
	   dbline[0] = '\0';
	   kcms_get_attribute(object, KCMS_CMOBJ_TOPSRC, &topsrc);
	}

	for (i = 0; i < num; i++)
	{
	   if (obj_flag == TRUE && (tmp = kstrrchr(list[i], '.')) != NULL)
	   {
	      tmp[1] = 'o'; tmp[2] = '\0';
	      if (kstrstr(unsharedobjs, list[i]) != NULL)
		 continue;
	   }
	   else if (type == KCMS_DIR &&
		    (kstrcmp(list[i], "..") == 0 ||
		     kstrcmp(list[i], "misc") == 0 ||
		     kstrcmp(list[i], "bootstrap") == 0 ||
		     kstrcmp(list[i], "hardcopy") == 0 ||
		     kstrcmp(list[i], "templates") == 0 ||
		     kstrcmp(list[i], "uis") == 0 ||
		     kstrcmp(list[i], "db") == 0 ||
		     kstrcmp(list[i], "man") == 0 ||
		     kstrcmp(list[i], "cat") == 0 ||
		     kstrcmp(list[i], "help") == 0 ||
		     kstrcmp(list[i], "info") == 0 ||
		     kstrcmp(list[i], "app-defaults") == 0))
	   {
	      continue;
	   }
	   else if (type == KCMS_MDIR &&
		    (kstrcmp(list[i], "..") == 0 ||
		     kstrcmp(list[i], "covers") == 0 ||
		     kstrcmp(list[i], "cover") == 0 ||
		     kstrcmp(list[i], "license") == 0 ||
		     kstrcmp(list[i], "hardcopy") == 0))
	   {
	      continue;
	   }
	   *empty = FALSE;
	   ksprintf(temp," \\\n\t%s", list[i]);
	   kstrcat(line, temp);

	   /* delete me kludge */
	   if (kcms_key != NULL)
	   {
	      ksprintf(temp,"%s/%s\n", topsrc, list[i]);
	      kstrcat(dbline, temp);
	   }
	}
	kfree(imakefile[entry]);
	imakefile[entry] = kstring_copy(line, NULL);

	/* delete me kludge */
	if (kcms_key != NULL && object != NULL)
	{
	   kdbm   *dbm;
	   kdatum key, data;
	   char   *opath;

	   kcms_get_attribute(object, KCMS_CMOBJ_OPATH, &opath);
	   ksprintf(temp,"%s/db/cms", opath);
	   if ((dbm = kdbm_open(temp, O_WRONLY | O_CREAT, 0666)) != NULL)
	   {
	      key.dptr   = kcms_key;
	      key.dsize  = kstrlen(key.dptr) + 1;
	      data.dptr  = dbline;
	      data.dsize = kstrlen(data.dptr) + 1;
	      kdbm_store(dbm, key, data, KDBM_REPLACE);
	      kdbm_close(dbm);
	   }
	}
	return(TRUE);
}


/*-----------------------------------------------------------
|  Routine Name: update_imakefile - update imakefile
|
|       Purpose: This routine does the actual work of creating the
|		 initial template according to the object's prog
|	         type and lang type.
|
|         Input: toolbox - the toolbox in which the object will be updated
|		 object  - the object in which we will update the imakefile
|		 type    - whether this is a directory rather than cms object
|		 imakefile - the path to the imakefile being updated
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Sep 10, 1993
------------------------------------------------------------*/

static int update_imakefile(
   kobject toolbox,
   kobject object,
   int     type,
   char    *imakefile)
{
	kfile *file;
	int   i, num, status, empty;
	char  **list, *tbname, *oname, field[KLENGTH], junk[KLENGTH],
	      directory[KLENGTH];


	empty = TRUE;
        kcms_get_attribute(toolbox, KCMS_TB_NAME, &tbname);
        if (type == 0)
	   kcms_get_attribute(object,  KCMS_CMOBJ_ONAME, &oname);
	else oname = "directory";

	if ((file = kfinput(imakefile)) == NULL)
	{
	   kerror(NULL, "update_imakefile", "Cannot open Imakefile for \
the cms object '%s' within the toolbox '%s'\n", oname, tbname);
	   return(FALSE);
	}

	if ((list = kparse_file_scan_delimit(file, KPARSE_BOF, KPARSE_EOF,
			KLITERAL, "\n", NULL, NULL, &num, &status)) == NULL)
	{
	   kerror(NULL, "update_imakefile", "Cannot read contents of \
Imakefile for the cms object '%s' within the toolbox '%s'\n", oname, tbname);
	   return(FALSE);
	}
	kfclose(file);

	/*
	 *  Update the Imakefile fields in the list
	 */
	kdirname(imakefile, directory);
	for (i = 0; i < num; i++)
	{
	   if (ksscanf(list[i]," #define %s", field) == 1 &&
		    kstrcmp(field, "EMPTY_FILE") == 0)
	   {
	      list = karray_delete(list, list[i], num);
	      num--;
	   }

	   if (ksscanf(list[i]," %s %s", field, junk) == 2 && junk[0] == '=')
	   {
	      if (kstrcmp(field, UNSHAREDOBJS) == 0)
		 unsharedobjs = kstrdup(list[i]);
	      if (!update_field(toolbox, object, type, directory, field, list,
			&empty, i))
	      {
	         return(FALSE);
	      }
	   }
	   else if (ksscanf(list[i]," #define %s", field) == 1 &&
		    kstrcmp(field, "DoNotAutoUpdate") == 0)
	   {
	     kerror(NULL, "update_imakefile", "Imakefile not modified `DoNotAutoUpdate' defined");
	      return(FALSE);
	   }
	   else
	   {
	      kre_comp("^#include\\s+.*_INCLUDE\\s*$");
	      if (kre_exec(list[i]))
	      {
		 ksprintf(field, "#include %s_INCLUDE",
			  kstring_upper(tbname, junk));
		 kfree(list[i]);
		 list[i] = kstring_copy(field, NULL);
	      }
	   }
	}

	/*
	 *  Open the Imakefile and write the puppy out
	 */
	if ((file = kfoutput(imakefile)) == NULL)
	{
	   kerror(NULL, "update_imakefile", "Cannot rewrite Imakefile \
for the cms object '%s' within the toolbox '%s'\n", oname, tbname);
	   return(FALSE);
	}

	/*
	 *  If this is an empty file then force imakefile to include an
	 *  empty template.
	 */
	if (empty == TRUE)
	   kfprintf(file, "#define EMPTY_FILE\n");

	/*
	 *  Dump the imakefile contents back into the file.
	 */
	for (i = 0; i < num; i++)
	   kfprintf(file, "%s\n", (!list[i] ? "" : list[i]));

	kfclose(file);
	return(TRUE);
}


/*-----------------------------------------------------------
|  Routine Name: generate_template - generate template imakefile
|
|       Purpose: This routine does the actual work of creating the
|		 initial template according to the object's prog
|	         type and lang type.
|
|         Input: object    - the object in which we will gen. the Imakefile
|		 type      - the type 
|		 imakefile - the imakefile path
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Sep 10, 1993
------------------------------------------------------------*/

static int generate_template(
   kobject object,
   int     type,
   char *imakefile)
{
	int  progtype, langtype;
        kstring  routine = "generate_template()";
	char *temp = NULL, *templates = NULL, template[KLENGTH];


	if (type == 0)
	{
           if (!kcms_get_attributes(object,
		    KCMS_CMOBJ_PROGTYPE, &progtype,
		    KCMS_CMOBJ_LANGTYPE, &langtype,
		    KCMS_END))
	   {
	      return FALSE;
	   }
	}
	else progtype = type;

	switch (progtype)
	{
	   case KCMS_DIR:
		templates = BOOTSTRAP_TEMPLATES;
		temp = DIRECTORY_TEMPLATE;
		break;

	   case KCMS_EXAMPLE:
		templates = BOOTSTRAP_TEMPLATES;
		temp = EXAMPLE_TEMPLATE;
		break;

	   case KCMS_XEXAMPLE:
		templates = BOOTSTRAP_TEMPLATES;
		temp = XEXAMPLE_TEMPLATE;
		break;

	   case KCMS_TESTSUITE:
		templates = BOOTSTRAP_TEMPLATES;
		temp = TESTSUITE_TEMPLATE;
		break;

	   case KCMS_KROUTINE:
		templates = BOOTSTRAP_TEMPLATES;
		if (langtype == KCMS_FORTRAN)
		   temp = FOR_PROGRAM_TEMPLATE;
		else
		   temp = PROGRAM_TEMPLATE;
		break;

	   case KCMS_XVROUTINE:
		templates = BOOTSTRAP_TEMPLATES;
		if (langtype == KCMS_FORTRAN)
		   temp = FOR_XPROGRAM_TEMPLATE;
		else
		   temp = XPROGRAM_TEMPLATE;
		break;

	   case KCMS_LIBRARY:
		templates = BOOTSTRAP_TEMPLATES;
		temp = LIBRARY_TEMPLATE;
		break;

	   case KCMS_SCRIPT:
		templates = BOOTSTRAP_TEMPLATES;
		if (langtype == KCMS_CSH)
		   temp = CSH_TEMPLATE;
		else if (langtype == KCMS_SH)
		   temp = SH_TEMPLATE;
		else if (langtype == KCMS_KSH)
		   temp = KSH_TEMPLATE;
		else if (langtype == KCMS_PERL)
		   temp = PERL_TEMPLATE;
		break;

	   case KCMS_PANE:
		templates = BOOTSTRAP_TEMPLATES;
		temp = PANE_TEMPLATE;
		break;

	   case KCMS_MANUAL:
		templates = DOCUMENTATION_TEMPLATES;
		temp = MANUAL_TEMPLATE;
		break;

	   case KCMS_MINDEX:
		templates = DOCUMENTATION_TEMPLATES;
		temp = MANUAL_INDEX_TEMPLATE;
		break;

	   case KCMS_MGLOSSARY:
		templates = DOCUMENTATION_TEMPLATES;
		temp = MANUAL_GLOSS_TEMPLATE;
		break;
	   case KCMS_MDIR:
		templates = DOCUMENTATION_TEMPLATES;
		temp = MANUAL_DIRECTORY_TEMPLATE;
		break;
	}
	ksprintf(template, "%s/%s", templates, temp);
	if (kaccess(template, R_OK) == -1)
	{
	   kerror(NULL, routine, "Could not read Imakefile template:\n\n"
		  "\t%s\n", template);
	   return FALSE;
	}
	if (!kcopyfile(template, imakefile))
	{
	   kerror(NULL, routine, "Could not copy Imakefile template:\n\n"
		  "\tTemplate    : %s\n"
		  "\tDestination : %s\n", template);
	   return(FALSE);
	}
	return(TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: generate_imakefile - generate imakefile
|
|       Purpose: This routine does the actual work of re-generating the
|		 Imakefile.
|
|         Input: tbname - the toolbox name
|                oname  - the object name in which we are to re-gen the
|			  Imakefile
|		 type   - if this is not an object, but a directory/manual
|			  imakefile
|		 recreate - whether to recreate the imakefile from scratch
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Sep 10, 1993
| Modifications:
|
------------------------------------------------------------*/

int generate_imakefile(
   char *tbname,
   char *oname,
   int  type,
   int  recreate)
{
	kfile *file;
	char *topsrc, temp[KLENGTH];
	kobject toolbox, object = NULL;


	/*
	 *  Open the toolbox
	 */
	if ((toolbox = kcms_open_toolbox(tbname)) == NULL)
	{
	   kerror(NULL, "generate_imakefile", "Cannot open toolbox object \
'%s'\n", tbname);
	    return(FALSE);
	}

	/*
	 *  Open the object
	 */
	if (type == 0 && (object = kcms_open_cmobj(toolbox, oname)) == NULL)
	{
	   kerror(NULL, "generate_imakefile", "Cannot open cms object '%s' \
within the toolbox '%s'\n", oname, tbname);
	   return(FALSE);
	}
 
	/*
	 *  Get Misc. information about the object
	 */
	if (type == 0)
           kcms_get_attribute(object, KCMS_CMOBJ_TOPSRC, &topsrc);
	else topsrc = ".";

	/*
	 *  Check to see if the Imakefile currently exists.  If not then
	 *  we will want to generate a template Imakefile according to it's
	 *  program type (progtype) and language type (langtype).  Or if the
	 *  recreate flag is specified then go ahead and regenerate it..
	 */
	ksprintf(temp, "%s/Imakefile", topsrc);
	if (recreate || kaccess(temp, R_OK) == -1)
	{
	   if (recreate == TRUE && (file = kfopen(temp, "r")) != NULL)
	   {
	      if (kparse_file_search(file, "^#define.*DoNotAutoRecreate",
		   		KIGNORE_CASE, NULL) == KPARSE_OK)
	      {
		 kerror(NULL, "generate_imakefile", "Imakefile not \
modified `DoNotAutoRecreate' defined");
		 kfclose(file);
		 return(FALSE);
	      }
	      kfclose(file);
	   }

	   if (!generate_template(object, type, temp))
	   {
	      return(FALSE);
	   }
	}

	/*
	 *  Now that we know that an Imakefile exists
	 */
	if (!update_imakefile(toolbox, object, type, temp))
	   return(FALSE);

	kchdir(topsrc);
	ksystem("kgenmake");
	return(TRUE);
}
