/*
 * Khoros: $Id$
 */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>             _static_routines()
   >>>>  Public:
   >>>>             public_routines()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kecho.h"

int reqtype = KCMS_KROUTINE;

/*-----------------------------------------------------------
| Routine Name: print_object_info - print software object information
|
| Purpose:	This function takes a software object, and prints out a
|		number of object attributes, in a format which is
|		conducive to being parsed.
|
| Input:	object - software object to print information for
| Returns:	TRUE (1) if the object information was successfully echoed,
|		FALSE (0) otherwise.
|
| Written By:	Neil Bowers
| Date:		18-aug-94
------------------------------------------------------------*/
int
print_object_info(
   kobject  object)
{
   kobject  toolbox;
   kobject  tbname;
   kstring  oname;
   kstring  category;
   kstring  subcategory;
   kstring  icon;
   kstring  description;
   kstring  bname;
   int      installed;
   int      otype;


   if (!kcms_get_attributes(object,
			    KCMS_NAME,               &oname,
			    KCMS_PARENT,             &toolbox,
			    KCMS_CMOBJ_CATEGORY,     &category,
			    KCMS_CMOBJ_SUBCATEGORY,  &subcategory,
			    KCMS_CMOBJ_ICON_NAME,    &icon,
			    KCMS_CMOBJ_BNAME,        &bname,
			    KCMS_CMOBJ_SHORT_DESC,   &description,
			    KCMS_CMOBJ_CI_INSTALLED, &installed,
			    KCMS_CMOBJ_PROGTYPE,     &otype,
			    KCMS_END)
       || !kcms_get_attribute(toolbox, KCMS_NAME, &tbname))
      return FALSE;

   if (clui_info->type_flag && otype != reqtype)
      return TRUE;

   kprintf("begin %s::%s\n", tbname, oname);
   kprintf("\tbinary-name=%s\n", (bname != NULL ? bname : ""));
   kprintf("\tcategory=%s\n",    (category != NULL ? category : ""));
   kprintf("\tsubcategory=%s\n", (subcategory != NULL ? subcategory : ""));
   kprintf("\tshort-description=%s\n", (description != NULL?description : ""));
   kprintf("\ticon-name=%s\n", (icon != NULL ? icon : ""));
   kprintf("\tin-cantata=%s\n", (installed ? "YES" : "NO"));
   kprintf("end %s::%s\n", tbname, oname);

   return TRUE;
}
