 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcp
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcp.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Copy a toolbox, software object, or file
|
|       Purpose: main program for kcp
|
|         Input:
|		Required M.E. group:
|		    M.I. group:
|			char *clui_info->otb_string; {origination toolbox}
|			int   clui_info->otb_flag; {TRUE if -otb specified}
|
|			char *clui_info->ntb_string; {destination toolbox}
|			int   clui_info->ntb_flag; {TRUE if -ntb specified}
|
|			char *clui_info->oname_string; {software object to be copied}
|			int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		    M.I. group:
|			char *clui_info->i_file; {original file}
|			int   clui_info->i_flag; {TRUE if -i specified}
|
|			char *clui_info->o_file; {copied file}
|			int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->force_flag; {TRUE if -force specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject otb = NULL, ntb = NULL, orig = NULL, new = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(kcp_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "kcp",
		kcp_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcp_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
/* -main_before_lib_call_end */

/* -main_library_call */
	if (clui_info->i_flag)
	{
	   if (!clui_info->force_flag && !koverwrite(KSTANDARD, clui_info->o_file))
	   {
	      kinfo(KSTANDARD, "\nAborting copying file from '%s' to '%s'\n",
		    clui_info->i_file, clui_info->o_file);
	      kexit(KEXIT_FAILURE);
	   }

	   if (kcopyfile(clui_info->i_file, clui_info->o_file) == -1)
	   {
	      kerror(NULL, "main()", "Couldn't copy data from file '%s' \
to file '%s'", clui_info->i_file, clui_info->o_file);
	      kexit(KEXIT_FAILURE);
	   }
	}
	else
	{
	   if ((otb = kcms_open_toolbox(clui_info->otb_string)) == NULL ||
	       (ntb = kcms_open_toolbox(clui_info->ntb_string)) == NULL ||
	       (orig = kcms_open_cmobj(otb, clui_info->oname_string)) == NULL)
	   {
	      (void) kerror(NULL, "main()", "Cannot open %s '%s'.",
			(!otb || !ntb) ? "toolbox" : "object",
			(!otb) ? clui_info->otb_string : 
			(!ntb) ? clui_info->ntb_string : 
			clui_info->oname_string);
	      kexit(KEXIT_FAILURE);
	   }

	   if (clui_info->force_flag)
	      kcms_set_bit(orig, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE);

	   if ((new = kcms_duplicate(orig, ntb)) == NULL)
	   {
	      kerror(NULL, "main()", "Could not copy '%s' from the toolbox \
'%s' to the toolbox '%s'\n", clui_info->oname_string, clui_info->otb_string,
			 clui_info->ntb_string);
	      kexit(KEXIT_FAILURE);
	   }
	   kcms_close(new); kcms_close(orig);
	   kcms_close(otb); kcms_close(ntb);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcp_usage_additions
| 
|       Purpose: Prints usage additions in kcp_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcp_usage_additions(void)
{
	kfprintf(kstderr, "\tCopy a toolbox, software object, or file\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcp_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcp_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcp_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->otb_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
