 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for conductor
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "conductor.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generates code for the GUI of an xvroutine.
|
|       Purpose: main program for conductor
|
|         Input:
|		char *clui_info->tb_string; {toolbox name}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {program object name}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		int clui_info->l_int; {Level of Extraction}
|		int clui_info->l_flag; {TRUE if -l specified}
|
|		int clui_info->force_flag; {TRUE if -force specified}
|
|		int clui_info->debug_flag; {TRUE if -debug specified}
|
|        Output:
|       Returns:
|
|    Written By: Danielle Argiro
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kstring  routine = "main()";
	kstring  tbname  = NULL;
	kstring  oname   = NULL;
	int	 ok;
	int      levels;
	kobject	 toolbox;
	kobject  program;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(conductor_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", 
			       "conductor", conductor_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	conductor_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/*-- were toolbox or object name given on the command-line? ---*/
	if (clui_info->tb_flag)
	   tbname = kstrdup(clui_info->tb_string);
	if (clui_info->oname_flag)
	   oname = kstrdup(clui_info->oname_string);

	/*-- if not, try and parse them from an Imakefile -------------*/
	if (!kcms_get_imake_symbols(&tbname, &oname, NULL, NULL))
	{
	   kerror(NULL, routine, "Could not determine toolbox and object "
		  "names, so nothing was generated\n");
	   kexit(KEXIT_FAILURE);
	}

	if ((toolbox = kcms_open_toolbox(tbname)) == NULL)
        {
            kerror(NULL, routine, "Cannot open toolbox object '%s'\n", tbname);
            kexit(KEXIT_FAILURE);
        }
	
        /*
         * try to open the object first
         */
        program = kcms_open_cmobj(toolbox, oname);

	/*
         * check to see if open failed because the object doesn't exist
         */
        if (program == NULL) 
        {
	    ok = kerror(NULL, routine, "Cannot open program object '%s'",
			oname);
            if (ok)
            {
		errno = KINTERNAL;
                kerror(NULL, routine,
                       "program object NULL, yet kcms_create returned OK");
            }
	    kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	/*
	 * get [-force] from command line 
	 */
	if (clui_info->force_flag)
		kcms_set_bit(program, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE);

	if (clui_info->debug_flag)
		kcms_set_bit(program, KCMS_CMOBJ_FLAGS,
			     KCMS_BIT_CMOBJ_GENDEBUG);

	/*
	 * get [-levels] from command line or *.cm file
	 */
	if (clui_info->l_flag)
	{
		levels = clui_info->l_int;
		(void) kcms_set_attribute(program, KCMS_CMOBJ_LEVELS, levels);
	}
	else
		(void) kcms_get_attribute(program, KCMS_CMOBJ_LEVELS, &levels);
	
	if ((levels != 1) && (levels != 2) && (levels != 3))
	{
	    kerror(NULL, routine,
		   "Invalid Level of Extraction value %d; "
		   "Level of Extraction MUST be 1, 2, or 3; "
		   "check *.cm file for error", levels);
	}
	else
	    (void) kgen_generate_gui(program);
/* -main_library_call_end */

/* -main_after_lib_call */
	kcms_close(program);
        kcms_close(toolbox);
	kfree(tbname);
	kfree(oname);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: conductor_usage_additions
| 
|       Purpose: Prints usage additions in conductor_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname conductor
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void conductor_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerates code for the GUI of an xvroutine.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: conductor_free_args
| 
|       Purpose: Frees CLUI struct allocated in conductor_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname conductor
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
conductor_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
