/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: This routine has the #includes needed for
   >>>>		       routines that use system dependant signal()
   >>>>
   >>>>    Written By: Mark Young
   >>>>          Date: May 25, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_kstatus_h_
#define _kutils_kstatus_h_

        /*-------------------------------------*
        |       #include 
        ---------------------------------------*/


        /*-------------------------------------*
        |       #defines 
        ---------------------------------------*/

/*
 *  Make sure WNOHANG & WUNTRACED are defined
 */
#ifndef WNOHANG
#define WNOHANG		1	/* Don't hang in wait */
#endif

#ifndef WUNTRACED
#define WUNTRACED	2	/* Tell about stopped, untraced children */
#endif

#ifndef WSTOPPED
#define WSTOPPED	0177	/* Tell if a process is stopped */
#endif

/*
 *  Define kstatus to be either a int or union wait
 */
#if (defined(SYSV) && KARCH_LOCAL != KARCH_IBMRT) || defined(_POSIX_SOURCE)

typedef int kstatus;

#ifndef WIFEXITED
#define WIFEXITED(x)	((x & 0xff) == 0)
#endif

#if (KARCH_LOCAL == KARCH_HP9000)
#undef  WEXITSTATUS
#undef  WTERMSIG
#endif

#ifndef WEXITSTATUS
#define WEXITSTATUS(x)  ((x >> 8) & 0xff)
#endif

#ifndef WTERMSIG
#define WTERMSIG(x)	(x & 0x7f)
#endif

#ifndef WIFSIGNALED
#define WIFSIGNALED(x)	((((x >> 8) & 0xff) == 0) && ((x & 0x7f) != 0))
#endif

#ifndef WIFSTOPPED
#define WIFSTOPPED(x)	((((x >> 8) & 0xff) != 0) && ((x & 0xff) == 0x7f))
#endif

#ifndef WSTOPSIG
#define WSTOPSIG(x)	((x >> 8) & 0xff)
#endif

#else

typedef union wait kstatus;

#ifndef WIFEXITED
#define WIFEXITED(x)	(((union wait *)&(x))->w_stopval != WSTOPPED && \
			 ((union wait *)&(x))->w_termsig == 0)
#endif

#ifndef WEXITSTATUS
#define WEXITSTATUS(x)	(((union wait *)&(x))->w_retcode)
#endif

#ifndef WIFSIGNALED
#define WIFSIGNALED(x)	(((union wait *)&(x))->w_stopval != WSTOPPED && \
			 ((union wait *)&(x))->w_termsig != 0)
#endif

#ifndef WTERMSIG
#define WTERMSIG(x)	(((union wait *)&(x))->w_termsig)
#endif

#ifndef WIFSTOPPED
#define WIFSTOPPED(x)	(((union wait *)&(x))->w_stopsig == WSTOPPED)
#endif

#ifndef WSTOPSIG
#define WSTOPSIG(x)	(((union wait *)&(x))->w_stopsig)
#endif

#endif

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/* kprocess.c */
int kwait3 	   PROTO((kstatus *, int, kaddr));

#endif /* _kutils_kstatus_h_ */
/* Don't add after the endif */
