/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: provide definitions and declarations necessary
   >>>>		       for the kutils string parsing routines.
   >>>>
   >>>>    Written By: Steven Jorgensen
   >>>>
   >>>>          Date: Aug 05, 1992 14:01
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_kparse_h_
#define _kutils_kparse_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

	/*
	 * used by kparse_file_scan and kparse_file_scan_delimit
	 * as special keys.  KPARSE_BOF says match the beginning of the file
	 * and KPARSE_EOF says match the end of the file
	 */

#define KPARSE_BOF	"BeginOfFile"
#define KPARSE_EOF	"EndOfFile"

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef enum {
	KPARSE_OK = 0,		/* parse went ok */
	KPARSE_NOKEY,		/* parser couldn't find the (begin) key */
	KPARSE_NOEND,		/* parser couldn't find the end key */
	KPARSE_DATAERR,		/* something was wrong with the data input */
	KPARSE_PARTKEY,		/* parser ran out of data midway through a */
				/* match on a (begin) key*/
	KPARSE_PARTEND,		/* parser ran out of data midway through a */
				/* match on an end key*/
	KPARSE_NULLKEY,		/* (begin) search key was NULL */
	KPARSE_NULLEND,		/* end search key was NULL */
	KPARSE_SYNTAXKEY,	/* search key had illegal syntax */
	KPARSE_SYNTAXEND	/* search end key had illegal syntax */
	} return_status;

typedef enum {
	KLITERAL = 0x0,
	KIGNORE_CASE = 0x1,
	KDELIM_CLEAN = 0x2
	} parse_mode;

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* parse.c */
char *kparse_string_search	    PROTO((char *,char *,int,char **,int *));
char *kparse_string_scan	    PROTO((char *, char *, char *, int, char **,
					   char **, int *));
char *kparse_file_scan		    PROTO((kfile *, char *, char *, int,
					   char **, char **, int *));
char **kparse_string_delimit	    PROTO((char *, char *, int, int *));
char **kparse_string_search_delimit PROTO((char *, char *, int, char *, char *,
					   char **, int *, int *));
char **kparse_file_search_delimit   PROTO((kfile *, char *, int, char *, char *,
					   char **, int *, int *));
char **kparse_string_scan_delimit   PROTO((char *, char *, char *, int, char *,
					   char **, char **, int *, int *));
char **kparse_file_scan_delimit     PROTO((kfile *, char *, char *, int, char *,
					   char **, char **, int *, int *));
int  kparse_file_search		    PROTO((kfile *, char *, int, char **));

#endif /* _kutils_kparse_h_ */
/* Don't add after this point */
