/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:  This include file contains the header
   >>>>			and define information required by the
   >>>>			internal Transport and File information
   >>>>
   >>>>    Written By:  Mark Young
   >>>>
   >>>>          Date: Jan 4, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_kfileP_h_
#define _kutils_kfileP_h_

        /*-------------------------------------*
        |       #include 
        ---------------------------------------*/


        /*-------------------------------------*
        |       #defines 
        ---------------------------------------*/


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

/*
 *   Definition for kfile structure, used by the internal reading & writing
 *   utilities.  This structure should not be manipulated by the application
 *   programmer but used as the "id" parameter for the public routines listed
 *   below.
 */
struct _kobject
{
	/*
	 *  Initial paramters used with the "open" initialization
	 *  routine.
	 */
	int	  id;		/* entry id within the kfile table           */
	char	  *path;	/* used to open kfile "identifier=token"     */
	int	  flags, mode;  /* flags & mode used in kopen()              */
	char	  *type;	/* type used when opening with kfopen()      */
	int	  state;	/* internal flags that are used to represent */
				/* the state of the transport object.        */

	/*
	 *  Parameters to support machine independence reading and writing
	 *
	 *  The machine type is used by the read/write utilities to perform
	 *  machine independent reads and writes.  Data is converted from
	 *  the external machine type to the "current" or "local" machine
	 *  type.
	 */
	long	  machtype;     /*  the machine type used by to read/write  */

	/*
	 *  Internalized buffer to do asynchronous operations (supported)
	 */
	kaddr	  addr;
	char	  *buf;
	int	  bufsiz;
	unsigned  int offset, num_bytes, position;

	/*
	 *  Need to maintain next and previous pointers for dup'ed objects.
	 *  Objects need to be seeked together..
	 */
	struct _kobject *next, *prev;


	/*
	 *  The "resources" structure is an internal pointer used by each of
	 *  the different transport drivers.  When initiailized the resource
	 *  pointer is used to hold specific information necessary for the
	 *  transport driver.  The different transports are called via the
	 *  "TransportRoutine" structure.
	 */
	kaddr	resources;
	struct _transport_info *routines;
};


typedef struct _transport_info
{
	char    *label;
	char    *identifier;
	int     data_permanence;

	int	(*tempnam)();
	int	(*open)();
	int	(*close)();
	int	(*read)();
	int	(*write)();
	int	(*lseek)();
	int	(*access)();
	int	(*unlink)();
	int	(*lock)();
	int	(*descriptors)();
} TransportInformation;


	/*-------------------------------------*
	|       macros
	---------------------------------------*/
#undef kfile_state
#define kfile_state(file) ((file)->state)

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

int ktransport_add	   PROTO((TransportInformation *));
int ktransport_delete	   PROTO((TransportInformation *));


#endif /* _kutils_kfileP_h_ */
/* don't add after the endif */
