/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                             <<<<
   >>>>       Purpose: Information structure for passing info       <<<<
   >>>>                between the form tree and the UIS file       <<<<
   >>>>		       via the forms parsing & deparsing routines   <<<<
   >>>>                                                             <<<<
   >>>>    Written By: Danielle Argiro                              <<<<
   >>>>                                                             <<<<
   >>>>          Date: Jul 7, 1992                                  <<<<
   >>>>                                                             <<<<
   >>>> Modifications: Converted from Khoros 1.0 (DA)               <<<<
   >>>>                                                             <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


#ifndef _kforms_uislineinfo_h_
#define _kforms_uislineinfo_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

	/*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*
 *  UIS control flags 
 */

#define	KUIS_STARTFORM	    1   /*  -F  : start of UIS                       */
#define KUIS_STARTMASTER    2   /*  -S  : start of master definition         */
#define KUIS_STARTSUBMENU   3   /*  -D  : start of subform definition        */
#define KUIS_STARTSUBFORM   4   /*  -M  : start of subform definition        */
#define	KUIS_STARTGUIDE	    5   /*  -G  : description of a guiding pane      */
#define	KUIS_STARTPANE      6   /*  -P  : description of a pane              */
#define KUIS_END            7   /*  -E  : end any database structure         */


/*
 *  UIS special purpose flags
 */

#define KUIS_MASTERACTION   8	/*  -n  : action button on Main form         */
#define KUIS_SUBFORMACTION  9   /*  -m  : action button on guide pane        */
#define KUIS_SUBFORMBUTTON  10  /*  -d  : subform button on Main form        */
#define	KUIS_GUIDEBUTTON    11  /*  -g  : guiding button controls which pane */	
#define KUIS_PSEUDOSUBFORM  12	/*  -u  : psuedo subform button on Main form */
#define KUIS_INCLUDESUBFORM 13	/*  -k  : include subform                    */
#define KUIS_INCLUDEPANE    14	/*  -p  : include pane file                  */


/*
 * KUIS general purpose flags
 */

#define	KUIS_INPUTFILE	   16	/*  -I  : input file argument/selection      */	
#define	KUIS_OUTPUTFILE	   17	/*  -O  : output file argument/selection     */	
#define KUIS_INTEGER   	   18	/*  -i  : integer argument/selection         */
#define KUIS_FLOAT   	   19 	/*  -f  : float argument/selection           */
#define KUIS_STRING   	   20	/*  -s  : string argument/selection          */
#define KUIS_LOGICAL       21   /*  -l  : boolean argument/selection         */
#define KUIS_CYCLE	   22	/*  -c  : cyclic selection                   */
#define KUIS_LIST	   23   /*  -x  : pulldown list selection            */
#define KUIS_TOGGLE   	   24	/*  -T  : toggle argument/selection          */
#define KUIS_MUTEXCL	   25	/*  -C  : mutually exclusive group           */
#define KUIS_MUTINCL	   26	/*  -B  : mutually inclusive group           */
#define KUIS_ROUTINE   	   27	/*  -R  : execute a routine                  */
#define KUIS_HELP   	   28	/*  -H  : display doc/man/help pages         */
#define	KUIS_QUIT	   29	/*  -Q  : quit button                        */	
#define KUIS_BLANK	   30	/*  -b  : blank selection                    */
#define KUIS_PANEACTION	   31	/*  -a  : action button                      */
#define KUIS_WORKSPACE	   32	/*  -w  : workspace object                   */
#define KUIS_FLAG          35	/*  -t  : flag selection                     */
#define KUIS_STRINGLIST    36	/*  -y  : string list selection              */
#define KUIS_DOUBLE        37	/*  -h  : double selection                   */
#define KUIS_GROUP         38	/*  -K  : loose group                        */
#define KUIS_OPTIONS       39	/* special define for cantata options button */
#define KUIS_DISPLAYLIST   40	/*  -z  : displayed list selection           */
#define KUIS_STDIN	   41	/*  -e  : standard input                     */
#define KUIS_STDOUT   	   42	/*  -o  : standard output                    */

#define KUIS_COMMENT       50	/*  #   : indicates comment in KUIS file     */

			        /* unused flags: jqrv FJNQUVWXY              */


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/


/*
 *    The Line_Info structure holds information 
 *    about GUI / CLUI items held in UIS line
 */

typedef struct _Line_Info {
	
/************   General Use   ************/

int  	 typeflag;       /* type of KUIS line                                */
int    	 activate;       /* true if item is activated                        */
int	 selected;       /* true if item is selected                         */
int	 optional;       /* true if item is optional                         */
int	 opt_sel;        /* true if optional item has been selected for use  */
int	 live;           /* true if item is "live"                           */


/************   Geometry   ************/

float	 width;          /* width of item (in characters)                    */
float    height;         /* height of item (in characters)                   */
float    x, y;           /* (x,y) position of item (in characters)           */
float	 xpos, ypos;     /* (x,y) offset of title (in characters)            */


/************   Values Entered By User   ************/

char     *title;	 /* title of item                                    */
char     *description;   /* description of item                              */
char     *variable;      /* variable name associated with item               */ 
char     *routine;       /* name of routine to execute (-R lines)            */
char     *help_file;     /* file with online help (-H lines)                 */
char     *filename;      /* filename entered (-I, -O, -A, -Z lines)          */
char     *string_val;    /* string value entered (-s lines)                  */
char     *literal;	 /* literal string rep. of selection value           */

int      int_val;        /* integer value entered (-i lines)                 */
int      logical_val;    /* logical value set (0 or 1)                       */
int      toggle_val;     /* toggle value set (0 to N, -T lines)              */
int      list_val;       /* list value set (1 to N, -x, -c, -y lines)        */
float    float_val;      /* float value entered (-f lines)                   */
double   double_val;     /* double value entered (-h lines)                  */

xvobject   workspace;    /* object address (-w lines)                        */

	/************   Values Set By Default   ************/

char    *string_def;     /* default string value                             */ 
char    *file_def;       /* default input or output file                     */ 
char    *lib_call;       /* library call                                     */

int     int_def;         /* default value of integer                         */
int     logical_def;     /* default value of boolean                         */
int     toggle_def;      /* default value of toggle                          */
float   float_def;       /* default value of float                           */
double  double_def;      /* default value of double                          */
		 

	/************   Bounds & Limits   ************/

int     lower_int;       /* lower bound on integer                           */
int     upper_int;       /* upper bound on integer                           */
float   lower_float;     /* lower bound on float                             */
float   upper_float;     /* upper bound on float                             */
double  lower_double;    /* lower bound on float                             */
double  upper_double;    /* upper bound on double                            */
int     list_num;        /* total number of list or cycle values             */
		

	/************   Odds & Ends   ************/

int	special;         /* unspecified integer for special-purpose fields   */
int	precision;       /* on doubles & floats: #decimal places to be used  */
int  	int_incr;        /* on integer selections, the increment value for sb */
float  	flt_incr;        /* on float selections, the increment value for sb   */
double 	dbl_incr;        /* on double selections, the increment value for sb  */
int	exec_bg;         /* execute a routine in background (-R lines)       */
int     exec_type;	 /* type of execution (-R lines)                     */
int	file_check;	 /* TRUE to error check validity of input file       */
int	write;		 /* 1 for writing UIS file w/o literals              */
int     val_labelnum;    /* number of allocated labels (for -c, -l, -x)      */

float   version;         /* version & release number of UIS def (-F lines)   */

char    **val_labels;   /* labels representing integer values, (-c, -l, -x)  */

} Line_Info;

	/*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

#endif /* _kforms_uislineinfo_h_ */
/* Don't add after the endif */
