/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: file structure to keep track of all different
   >>>>		       forms a file can appear as.  This is
   >>>>		       the actual structure definition of the kobject
   >>>>		       with the type KOBJ_CMSFILE
   >>>>
   >>>>    Written By: Steven Jorgensen
   >>>>
   >>>>          Date: Apr 14, 1993 01:26
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_fileobj_h_
#define _kcms_fileobj_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/

	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

#define	KCMS_FOBJ_OFFSET	600     /* offset into attributes table  */
#define KCMS_FOBJ_MAX		 14     /* number of attributes in table */

/*-- common attributes -----------------------------------------------*/

#define KCMS_FOBJ_BASENAME	1
				/* KCMS_TYPE is #2 */
#define KCMS_FOBJ_FULLNAME	3
#define KCMS_FOBJ_PARENTOBJ	4
				/* KCMS_DATE is #2 */


/*-- file-specific attributes ----------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	KCMS_FOBJ_TYPE
| Type:		int
| Description:	The type of the the file object.
| Legal Values:	KCMS_FOBJ_TYPE_MISC
|		KCMS_FOBJ_TYPE_SRC
|		KCMS_FOBJ_TYPE_MAN
|		KCMS_FOBJ_TYPE_HELP
|		KCMS_FOBJ_TYPE_MANUAL
|		KCMS_FOBJ_TYPE_UIS
|		KCMS_FOBJ_TYPE_SCRIPT
|		KCMS_FOBJ_TYPE_DBM
|		KCMS_FOBJ_TYPE_INFO
|		KCMS_FOBJ_TYPE_CONFIG
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_FOBJ_TYPE			6

/*------------------------------------------------------------------------
| Attribute:	KCMS_FOBJ_SUBTYPE
| Type:		int
| Description:	The subtype of the file object.  Valid types are determined
|		by the file type of the object, which is specified with
|		the
|		.symbol - KCMS_FOBJ_TYPE
|		attribute.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_FOBJ_SUBTYPE		7

/*------------------------------------------------------------------------
| Attribute:	KCMS_FOBJ_GENERATED
| Type:		int
| Description:	A boolean flag which specifies whether this file was
|		generated or not.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_FOBJ_GENERATED		8

/*------------------------------------------------------------------------
| Attribute:	KCMS_FOBJ_ACCESS
| Type:		int
| Description:	The access permissions on the file itself.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_FOBJ_ACCESS		9

/*------------------------------------------------------------------------
| Attribute:	KCMS_FOBJ_DIRNAME
| Type:		kstring
| Description:	The fullpath of the directory which contains this file.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_FOBJ_DIRNAME		10

/*------------------------------------------------------------------------
| Attribute:	KCMS_FOBJ_DIRNAME_TKN
| Type:		int
| Description:	The token associated with the value of the
|		.symbol - KCMS_FOBJ_DIRNAME
|		attribute.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_FOBJ_DIRNAME_TKN		11

/*------------------------------------------------------------------------
| Attribute:	KCMS_FOBJ_BASENAME_TKN
| Type:		int
| Description:	The token associated with the value of the KCMS_NAME
|		attribute, the basename of the file.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_FOBJ_BASENAME_TKN		12

/*------------------------------------------------------------------------
| Attribute:	KCMS_FOBJ_FULLNAME_TKN
| Type:		int
| Description:	The token associated with the full path (KCMS_PATH) of
|		the file.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_FOBJ_FULLNAME_TKN		13

/*------------------------------------------------------------------------
| Attribute:	KCMS_FOBJ_MODIFIED
| Type:		int
| Description:	A boolean attribute which specifies whether the file
|		has been modified.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_FOBJ_MODIFIED		14


/* KCMS_FOBJ_TYPE can be one of: */
#define KCMS_FOBJ_TYPE_MISC	0	/* misc files, no subtypes          */
#define KCMS_FOBJ_TYPE_SRC	1	/* src file, see src subtypes       */
#define KCMS_FOBJ_TYPE_MAN	2	/* man file, see man subtypes       */
#define KCMS_FOBJ_TYPE_HELP	3	/* help file, see help subtypes     */
#define KCMS_FOBJ_TYPE_MANUAL	4	/* manual file, see manual subtypes */
#define KCMS_FOBJ_TYPE_UIS	5	/* UIS file, see manual subtypes    */
#define KCMS_FOBJ_TYPE_SCRIPT	6	/* script file, see script subtypes */
#define KCMS_FOBJ_TYPE_DBM	7	/* database file, see dbm subtypes  */
#define KCMS_FOBJ_TYPE_INFO	8	/* object info: todo, bugs & done   */
#define KCMS_FOBJ_TYPE_CONFIG	10	/* configuration, imake and similar */

/* KCMS_FOBJ_SUBTYPE can be one of: */

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_MISC   */
#define KCMS_FOBJ_SUBTYPE_NONE	   -1	/* no subtype                        */

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_SRC    */
#define KCMS_FOBJ_SUBTYPE_C	    0	/* C src file, suffix (.c)           */
#define KCMS_FOBJ_SUBTYPE_INCL	    1	/* header file, suffix (.h)          */
#define KCMS_FOBJ_SUBTYPE_FORTRAN   2	/* FORTRAN file, suffix (.f)         */
#define KCMS_FOBJ_SUBTYPE_CPLUSPLUS 3	/* C++ file, suffixes (.cxx, .C .cc) */
#define KCMS_FOBJ_SUBTYPE_OBJC	    4	/* Objective-C file, suffix (.m)     */
#define KCMS_FOBJ_SUBTYPE_YACC	    5	/* YACC or bison file, suffix (.y)   */
#define KCMS_FOBJ_SUBTYPE_LEX	    6   /* (f)lex file, suffixes (.l, .lex)  */

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_MAN    */
#define KCMS_FOBJ_SUBTYPE_MAN1	   0	/* program man file, in $TB/man1 dir */
#define KCMS_FOBJ_SUBTYPE_MAN3	   1	/* library man file, in $TB/manoname */
#define KCMS_FOBJ_SUBTYPE_CAT1	   2	/* program cat file, in $TB/cat1 dir */
#define KCMS_FOBJ_SUBTYPE_CAT3	   3	/* library cat file, in $TB/catoname */

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_HELP   */
#define KCMS_FOBJ_SUBTYPE_DOC	   0	/* user help file, suffix (.doc)      */
#define KCMS_FOBJ_SUBTYPE_HELP	   1	/* generated help file, suffix (.hlp) */
#define KCMS_FOBJ_SUBTYPE_FORMATTED   2	/* formatted doc or help file         */

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_MANUAL */
#define KCMS_FOBJ_SUBTYPE_MS	   0	/* generated ms manual file (.ms)   */
#define KCMS_FOBJ_SUBTYPE_MAN	   1	/* user written manual file (.man)  */
#define KCMS_FOBJ_SUBTYPE_SEC	   2	/* user written section file (.sec) */
#define KCMS_FOBJ_SUBTYPE_PS	   3	/* generated postscript file (.ps)  */

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_UIS    */
#define KCMS_FOBJ_SUBTYPE_FORM		0
#define KCMS_FOBJ_SUBTYPE_PANE		1
#define KCMS_FOBJ_SUBTYPE_MISC		2

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_SCRIPT */
#define KCMS_FOBJ_SUBTYPE_SH	   0	/* Bourne Shell file (.sh)  */
#define KCMS_FOBJ_SUBTYPE_PERL	   1	/* PERL script file (.perl) */
#define KCMS_FOBJ_SUBTYPE_CSH	   2	/* C-Shell file (.csh)      */
#define KCMS_FOBJ_SUBTYPE_TCSH	   3	/* Cornell's C-Shell (.csh) */

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_DBM	 */
#define KCMS_FOBJ_SUBTYPE_CM	    0	/* Config Management file (.cm)   */
#define KCMS_FOBJ_SUBTYPE_CI	    1	/* Category Info file (.ci)       */
#define KCMS_FOBJ_SUBTYPE_SDBM_DIR  2	/* A SDBM Dir file (.dir)         */
#define KCMS_FOBJ_SUBTYPE_SDBM_PAG  3	/* A SDBM Page file (.pag)        */
#define KCMS_FOBJ_SUBTYPE_WORKSPACE 4	/* A saved workspace file	*/

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_INFO */
#define KCMS_FOBJ_SUBTYPE_TODO		0
#define KCMS_FOBJ_SUBTYPE_BUGS		1
#define KCMS_FOBJ_SUBTYPE_DONE		2
#define KCMS_FOBJ_SUBTYPE_CHANGELOG	3
#define KCMS_FOBJ_SUBTYPE_DESCRIPTION	4

/* IFF KCMS_FOBJ_TYPE == KCMS_FOBJ_TYPE_CONFIG */
#define KCMS_FOBJ_SUBTYPE_IMAKE_CONFIG	0
#define KCMS_FOBJ_SUBTYPE_IMAKEFILE	1
#define KCMS_FOBJ_SUBTYPE_MAKEFILE	2
#define KCMS_FOBJ_SUBTYPE_ALIAS_FILE	3
#define KCMS_FOBJ_SUBTYPE_APP_DEFAULTS	4

/* KCMS_FOBJ_GENERATED can be one of: (NOTE first six have keys) */
#define KCMS_FOBJ_GEN_NONE	   -1   /* wasn't generated          */
#define KCMS_FOBJ_GEN_MAIN	   0    /* *.c                       */
#define KCMS_FOBJ_GEN_INCL	   1    /* *.h                       */
#define KCMS_FOBJ_GEN_LFILE	   2    /* library file              */
#define KCMS_FOBJ_GEN_MAN1	   3    /* *.1                       */
#define KCMS_FOBJ_GEN_MAN3	   4    /* *.3                       */
#define KCMS_FOBJ_GEN_HELP	   5    /* *.hlp                     */
#define KCMS_FOBJ_GEN_GWFILE	   6    /* usage.c                   */
#define KCMS_FOBJ_GEN_LINCL	   7    /* lib's public include file */
#define KCMS_FOBJ_GEN_DOFILE	   8    /* do_{name}.c               */
#define KCMS_FOBJ_GEN_COND	   9    /* form_info.h, form_info.c, */
				        /* form_drv.c,  form_init.c  */
#define KCMS_FOBJ_GEN_SCRIPT	  10    /* *.sh                      */

/* KCMS_FOBJ_ACCESS can be one of: */
#define KCMS_FOBJ_ACCESS_RDWR	   0	/* Read/Write Access */
#define KCMS_FOBJ_ACCESS_RDONLY	   1	/* Read Only  Access */

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/


#endif /* _kcms_fileobj_h_ */
/* Don't add after this point */
