/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Include file for KCMS common attributes
   >>>>
   >>>>    Written By: Neil Bowers
   >>>>
   >>>>          Date: Jun 17 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_attributes_h_
#define _kcms_attributes_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/

	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

/*-----------------------------------------------------------------------
| KCMS_END is the marker for the end of varargs attribute list.  Ie the
| end marker for a kcms_get_attributes() or kcms_set_attributes() call.
-----------------------------------------------------------------------*/
#define KCMS_END			0

/*------------------------------------------------------------------------
| Attribute:	KCMS_NAME
| Type:		kstring
| Description:	The name of the kcms object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_NAME			1

/*------------------------------------------------------------------------
| Attribute:	KCMS_TYPE
| Type:		int
| Description:	The type of kcms object.
| Legal Values:	KOBJ_CMSTB
|		KOBJ_CMSOBJ
|		KOBJ_CMSFILE
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TYPE			2

/*------------------------------------------------------------------------
| Attribute:	KCMS_PATH
| Type:		kstring
| Description:	The path to the object.
|		If possible the path is given relative to the top of a
|		toolbox, using the $TOOLBOX notation.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_PATH			3

/*------------------------------------------------------------------------
| Attribute:	KCMS_PARENT
| Type:		kobject
| Description:	This attribute holds the parent object of the current object.
|		This will always be
|		.symbol - NULL
|		for a toolbox object, in the current version of kcms.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_PARENT			4

/*------------------------------------------------------------------------
| Attribute:	KCMS_DATE
| Type:		kstring
|		kstring
|		kstring
| Description:	This attribute holds three date strings associated with
|		the object: the date created, date last modified, and
|		date last generated (by the Khoros code generators).
|		Note that for a file object, you cannot get the date
|		created (a restriction inherited from UNIX), and the
|		date of generation will be the date when the software
|		object was last generated.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_DATE			5


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/


#endif /* _kcms_attributes_h_ */
/* Don't add after this point */
