#include "bootstrap.h"

static int get_and_prompt(
   int   notify,
   char *yes_response,
   char *no_response,
   int   default_val,
   char *message,
   kvalist)
  {
    kva_list args;
    int val;

    kinfo(KSTANDARD,"get some info from a file, and prompt\n");
    kva_start(args, message);
    val = kvprompt(notify, yes_response, no_response, default_val, message, args);
    kva_end(args);
    return(val);
  }

static void get_and_choose(
   int    notify,
   char **options,
   int    opt_cnt,
   int    default_val,
   char  *return_string,
   int   *return_index,
   char  *message,
   kvalist)
  {
    kva_list args;

    kinfo(KSTANDARD,"get some info from disk, and prompt\n");
    kva_start(args, message);
    kvchoose(notify, options, opt_cnt, default_val, return_string, return_index, message, args);
    kva_end(args);
  }

main(
   int argc,
   char *argv[],
   char *envp[])
  {
    int val;
    char *options[] = { "down", "up", "right", "left" };
    khoros_initialize(argc, argv, envp, "BOOTSTRAP");

    kinfo(KSTANDARD, "This routine shows examples of how to call kchoose, kvchoose, kprompt, and kvprompt\n");

    kinfo(KSTANDARD, "The routine kchoose, allows the programmer to select one of 2 or more choices.  The following example has 4 choices.  The prompt can have printf formtting syntax.\n");

    kchoose(KSTANDARD, options, 4, 3, NULL, &val, "Which direction shall %s go? ", "the blue dot");

    kinfo(KSTANDARD, "The choice you made was '%d'\n", val);

    kinfo(KSTANDARD, "Now, we use kvchoose to allow a query to be combined with another action\n");

    get_and_choose(KSTANDARD, options, 4, 3, NULL, &val, "Which direction shall we go? ");

    kinfo(KSTANDARD, "The choice you made was '%d'\n", val);

    kinfo(KSTANDARD, "The routine kprompt, allows the programmer to as a 'yes' or 'no' question.  Acceptable responses default to 'Yes', or 'No'; however, they can be redefined if necessary.  The following example asks whether the user wishes to continue or stop.  As with kchoose, the prompt message can contain printf formatting syntax.\n");
    if (kprompt(KSTANDARD, "Cont", "Stop", 1, "Your data in '%s' may have been corrupted, what should I do?", "myfile.c"))
      kinfo(KSTANDARD, "You choose to Continue\n");
    else
      kinfo(KSTANDARD, "You choose to Stop\n");

    kinfo(KSTANDARD, "Now, we use kvprompt, to allow a prompt to be combined with another action\n");

    if (get_and_prompt(KSTANDARD, "Cont", "Stop", 1, "Your data in '%s' may have been corrupted, what should I do?", "myfile.c"))
      kinfo(KSTANDARD, "You choose to Continue\n");
    else
      kinfo(KSTANDARD, "You choose to Stop\n");
  }
