#include <bootstrap.h>
#include "ksdbm.h"
#include <klibdb/kdbm.h>
 
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	ksdbm *ksdbm;
	ksdatum skey, sdata;
	kdbm *dbm;
	kdatum key, data;
	char *path = NULL;
	char *pathnew = NULL;


	if (argc > 2)
	{
	   path = argv[1];
	   pathnew = argv[2];
	}
	else
	{
	   kinfo(KSTANDARD, "example: You must supply the path to the database \
that is to be converted");
	   kexit(KEXIT_FAILURE);
	}

	if (!(ksdbm = ksdbm_open(path, O_RDONLY, 0666)))
	{
	   kinfo(KSTANDARD, "example:  Failed to open database '%s'", path);
	   kexit(KEXIT_FAILURE);
	}

	if (!(dbm = kdbm_open(pathnew, O_WRONLY|O_CREAT|O_TRUNC, 0666)))
	{
	   kinfo(KSTANDARD, "example:  Failed to create database '%s'", path);
	   kexit(KEXIT_FAILURE);
	}

	for (skey = ksdbm_firstkey(ksdbm); skey.dptr != NULL;
	     skey = ksdbm_nextkey(ksdbm))
	{
	   sdata = ksdbm_fetch(ksdbm, skey);
	   key.dptr  = skey.dptr;
	   key.dsize = skey.dsize;
	   data.dptr  = sdata.dptr;
	   data.dsize = sdata.dsize;
	   kdbm_store(dbm, key, data, KDBM_REPLACE);
	}
	ksdbm_close(ksdbm);
	kdbm_close(dbm);
	kexit(0);
}
