#include "bootstrap.h"
#include "klibdb/kdbm.h"
 
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kdbm *dbm;
	kdatum key, data;
	char   *path = "$bootstrap/repos/db/manpage";

	kfile *file;
	char *tmpfile, buffer[KLENGTH], tmp1[KLENGTH], tmp2[KLENGTH];


	if (argc > 1)
	   path = argv[1];

	tmpfile = ktempnam(NULL, "exampleXXX");
	if ((dbm = kdbm_open(path, O_RDONLY, 0666)) != NULL)
	{
	   if (!(file = kfoutput(tmpfile)))
	   {
	      kinfo(KSTANDARD, "example:  Failed to open temporary file '%s'",
			tmpfile);
	      kexit(1);
	   }

	   for (key = kdbm_firstkey(dbm); key.dptr != NULL;
		key = kdbm_nextkey(dbm))
	   {
	      data = kdbm_fetch(dbm, key);
	      kfprintf(file, "%s - %s\n", key.dptr, data.dptr);
	   }
	   kfclose(file);
	   kdbm_close(dbm);
	}

	keditfile(tmpfile, FALSE, NULL);
	if (!(dbm = kdbm_open(path, O_WRONLY | O_CREAT | O_TRUNC, 0666)))
	{
	   kinfo(KSTANDARD, "example:  Failed to open database '%s'", path);
	   kexit(1);
	}

	if ((file = kfinput(tmpfile)) != NULL)
	{
	   key.dptr  = tmp1;
	   data.dptr = tmp2;
	   while (!kfeof(file))
	   {
	      if (kfgets(buffer, KLENGTH, file) != NULL)
	      {
		 ksscanf(buffer," %s - %s\n", key.dptr, data.dptr);
		 key.dsize  = kstrlen(key.dptr) + 1;
		 data.dsize = kstrlen(data.dptr) + 1;
		 kdbm_store(dbm, key, data, KDBM_REPLACE);
	      }
	   }
	   kunlink(tmpfile);
	}
	kexit(0);
}
