.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DpUpdVarQuadMesh 3D  "Dore"
.SH NAME
DpUpdVarQuadMesh \- Update a variable quadrilateral mesh primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DpUpdVarQuadMesh(object, vertlocs, 
		vertnorms, vertcolors,
		recompute_norms)
DtObject object;
DtReal vertlocs[\|];
DtReal vertnorms[\|];
DtReal vertcolors[\|];
DtFlag recompute_norms;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DPUVQM(OBJECT, VTXLOC, VTXNRM, 
		VTXCLR, CMPNRM)
INTEGER*4 OBJECT
REAL*8 VTXLOC(3,*)
REAL*8 VTXNRM(3,*)
REAL*8 VTXCLR(*,*)
INTEGER*4 CMPNRM
.fi
.SH DESCRIPTION 
.IX DpUpdVarQuadMesh
.IX DPUVQM
.I DpUpdVarQuadMesh 
updates a variable quadrilateral mesh primitive object.
.PP
The parameter \f2object\fP is the handle to the object. 
.PP
The parameter \f2vertlocs\fP is an array of vertex locations.
If the vertex locations have not been modified use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
The number of vertices, the number of quadrilaterals, and the mesh
connectivity cannot be modified.
.PP
The parameter \f2vertnorms\fP is an array of vertex normals.
If the vertex normals have not been modified use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
\f2vertnorms\fP must be a null pointer if vertex normals were
not provided when the object was created with \f2DoVarQuadMesh\fP
<\f2DOVQDM\fP>.
.PP
The parameter \f2vertcolors\fP is an array of vertex colors.
If the vertex colors have not been modified use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
\f2vertcolors\fP must be a null pointer if vertex colors were 
not provided when the object was created with \f2DoVarQuadMesh\fP
<\f2DOVQDM\fP>.
.PP
The parameter \f2recompute_norms\fP specifies whether normals 
should be recomputed if \f2vertlocs\fP is not null. 
The vertex normals will only be recomputed if
\f2smoothflag\fP was set when the object was created with 
\f2DoVarQuadMesh\fP <\f2DOVQDM\fP>, and if the shading needs them.
.SH ERRORS
.I DpUpdVarQuadMesh
will issue a warning if a zero vertex normal is calculated by Dore.
.PP 15
[WARNING - quadrilateral normals sum to 0 at vertex, check for back to back quadrilateral]
.PP
.I DpUpdVarQuadMesh
will fail if an invalid object is specified.
.PP 15
[WARNING - invalid or deleted object]
.PP
.I DpUpdVarQuadMesh
will fail if vertex normals are specified for an object that did not
possess them originally.
.PP 15
[WARNING - value out of range]
.PP
.I DpUpdVarQuadMesh
will fail if vertex colors are specified for an object that did not
possess them originally.
.PP 15
[WARNING - value out of range]
.SH "SEE ALSO"
DoVarQuadMesh(3D)
