.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoVarSimplePolygonMesh 3D  "Dore"
.SH NAME
DoVarSimplePolygonMesh \- Create a variable simple polygon mesh primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoVarSimplePolygonMesh(colormodel, 
	vertexcount, vertlocs, vertnorms, 
	vertcolors, polygoncount, contours, 
	vertexlist, shape, smoothflag)
DtColorModel colormodel;
DtInt vertexcount;
DtReal vertlocs[\|];
DtReal vertnorms[\|];
DtReal vertcolors[\|];
DtInt polygoncount;
DtInt contours[\|];
DtInt vertexlist[\|];
DtShapeType shape;
DtFlag smoothflag;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOVSPM(COLMOD, VTXCNT, VTXLOC, 
		VTXNRM, VTXCLR, PLYCNT, 
		CONTURS, VTXLST, SHAPE, 
		SMOOFL)
INTEGER*4 COLMOD
INTEGER*4 VTXCNT
REAL*8 VTXLOC(*)
REAL*8 VTXNRM(*)
REAL*8 VTXCLR(*)
INTEGER*4 PLYCNT
INTEGER*4 CONTURS(PLYCNT)
INTEGER*4 VTXLST(*)
INTEGER*4 SHAPE
INTEGER*4 SMOOFL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOVSPM
.IX DoVarSimplePolygonMesh
.I DoVarSimplePolygonMesh
creates a primitive object that defines a variable collection of simple
polygons, normally interconnected.
.PP
The main difference between a variable simple polygon mesh and a
simple polygon mesh is that the variable mesh does not copy the 
vertex data into its own data space.  
It simply maintains pointers to the vertex data 
(locations, normals and colors) in user space.  
A call to \f2DpUpdVarSimplePolygonMesh\fP <\f2DPUVSM\fP> informs an 
object that the user data has changed.
Each simple polygon must be as described in \f2DoSimplePolygon\fP,
with the additional restriction that the shape must not be
\f2DcComplex\fP <\f2DCCPLX\fP>.
.PP
The parameter \f2colormodel\fP specifies the color model used if 
vertex colors are specified.  
The parameter \f2vertexcount\fP specifies the number of vertices.
The parameter \f2vertlocs\fP is an array of vertex locations. 
The parameter \f2vertnorms\fP is an array of vertex normals.
If vertex normals are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
The parameter \f2vertcolors\fP is an array of vertex colors.
If vertex colors are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
.PP
The parameter \f2polygoncount\f1 specifies the number of polygons
in the mesh.  Simple polygons are each composed of one contour.
The parameter \f2contours\f1 is an array of \f2polygoncount\f1
integers, each of which specifies the number of vertices in the associated
polygon. 
.PP
The parameter \f2vertexlist\f1 is an array of integers that index the
\f2vertices\f1 array.  The first polygon in the mesh begins with the
vertex specified by \f2vertexlist[0]\f1, and continues using the vertices
specified by the following entries in \f2vertexlist\f1.
The last vertex of a contour is implicitly connected to its
first vertex.  The next polygon begins with the vertex specified next
in the \f2vertexlist\f1 array.
.PP
The parameter \f2shape\fP hints at the geometry of the polygons in the mesh.
For these polygons, correctly specifying the shape of the polygon
will result in optimal polygon decomposition when necessary.
Incorrectly specifying the shape may result in an incorrect or aborted
decomposition.  The possible values for \f2shape\fP are:
.IP "\f2DcConvex\fP <\f2DCCNVX\fP>"
Path is wholly convex.
.IP "\f2DcConcave\fP <\f2DCCNCV\fP>"
Path may be concave but not self-intersecting.
.PP
Note that the shape must \f2not\fP be \f2DcComplex\fP <\f2DCCPLX\fP>. 
.PP
The parameter \f2smoothflag\fP specifies that if vertex normals
are not provided, the average normal of the geometric normals from a vertex's
adjacent surfaces constitute the normal for vertex shading.  (This
assumes the simple polygon mesh defines a smooth surface.)
.PP
The geometric normal to each polygon is calculated 
using the right-hand rule
(when the fingers of the right hand point in the order of the vertices,
the thumb points in the direction of the normal).  
Dore uses these normals for backface culling and 
facet shading.
.SH ERRORS
\f2DoVarSimplePolygonMesh\fP must be called with
a valid specification for \f2shape\fP.
.PP 15
[WARNING - invalid parameter]
.PP
\f2DoVarSimplePolygonMesh\fP must be called with at least three vertices.
.PP 15
[WARNING - insufficient information]
.PP
.I DoVarSimplePolygonMesh
will issue a warning if a zero vertex normal is calculated by Dore.
.PP 15
[WARNING - triangle normals sum to 0 at vertex, check for back to back triangles]
.PP
.I DoVarSimplePolygonMesh
will fail if the polygon is specified as \f2DcComplex\fP.
.PP 15
[WARNING - value out of range]
.SH "SEE ALSO"
.na
.nh
DpUpdVarSimplePolygonMesh(3D), DoSimplePolygonMesh(3D), DoVarLineList(3D),
DoVarPointList(3D), DoVarTriangleMesh(3D),
DoVarTriangleStrip(3D)
.ad
.hy
