.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoVarQuadList 3D  "Dore"
.SH NAME
DoVarQuadList \- Create a variable quadrilateral list primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoVarQuadList(colormodel,
		vertlocs, vertnorms, vertcolors, quadcount)
DtColorModel colormodel;
DtReal vertlocs[\|];
DtReal vertnorms[\|];
DtReal vertcolors[\|];
DtInt quadcount;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOVQDL(COLMOD, VTXLOC, VTXNRM, VTXCLR, QUDCNT)
INTEGER*4 COLMOD
REAL*8 VTXLOC(*)
REAL*8 VTXNRM(*)
REAL*8 VTXCLR(*)
INTEGER*4 QUDCNT
.fi
.SH DESCRIPTION 
.IX DOVQDL
.IX DoVarQuadList
.I DoVarQuadList 
creates a primitive object that defines a variable
list of independent quadrilaterals.
.PP
The main difference between a variable quadrilateral list and a 
quadrilateral list is that a variable quadrilateral list does not 
make a copy of the vertex data into its own data space.  
It simply maintains pointers to the vertex data 
(locations, normals and colors) in user space.  
A call to \f2DpUpdVarQuadList\fP <\f2DPUVQL\fP> informs a 
variable quadrilateral list object that the user data has changed.
.PP
The parameter \f2colormodel\fP specifies the color model used if 
vertex colors are provided.
The parameter \f2vertlocs\fP is an array of vertex locations.
The parameter \f2vertnorms\fP is an array of vertex normals.
If vertex normals are not available use \f2DcNullPtr\fP <\f2DCNULL\fP>.
The parameter \f2vertcolors\fP is an array of vertex colors. 
If vertex colors are not available use \f2DcNullPtr\fP <\f2DCNULL\fP>.
.PP
The parameter \f2quadcount\fP specifies the total number of 
quadrilaterals in the mesh.  Therefore, \f2vertlocs\fP -- and when
supplied, \f2vertnorms\fP and \f2vertcolors\fP -- must contain data 
for 4*\f2quadcount\fP vertices.
.PP
The geometric normal to each quadrilateral is calculated using the right-hand rule
(when the fingers of the right hand point in the order of the vertices,
the thumb points in the direction of the normal).  These geometric normal
calculations require that all quadrilaterals be planar.
These normals are sometimes used for backface culling and
facet shading.
.PP
Texture mapping indices are assigned to variable quadrilateral lists 
using the \f2DpUpdVarQuadListUV\f1 and \f2DpUpdVarQuadListUVW\f1 functions.
.SH ERRORS
\f2DoVarQuadList\fP must be called with at least four vertices.
.PP
[WARNING - invalid parameter]
.PP
.I DoVarQuadList
will issue a warning if a zero vertex normal is calculated by Dore.
.PP
[WARNING - quad normals sum to 0 at vertex, check for back to back quads]
.SH "SEE ALSO"
.na
.nh
DpUpdVarQuadList(3D), DoQuadList(3D), DoVarLineList(3D),
DoVarPointList(3D), DoVarSimplePolygonMesh(3D),
DoVarTriangleStrip(3D), *** UPDATE THIS!!! ***
.ad
.hy
