.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTranspColor 3D  "Dore"
.SH NAME
DoTranspColor \- Create a transparent color primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTranspColor(colormodel, color)
DtColorModel colormodel;
DtReal color[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTC(COLMOD, COLOR)
INTEGER*4 COLMOD
REAL*8 COLOR(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTC
.IX DoTranspColor
\f2DoTranspColor\fP creates a transparent color primitive attribute object.
The parameter \f2colormodel\fP specifies the color model.
The parameter \f2color\fP specifies the color of the light
that can be transmitted through the surface.
In effect, the transparent
color of an object can be thought of as its filter color.
.PP
The transparent color is one of several qualities 
that make a surface transparent.
Other qualities include the intensity of the transparent color 
(set with \f2DoTranspIntens <DOTI>\fP)
and the presence of transparency (set with \f2DoTranspSwitch <DOTS>\fP).
.PP
The use of this attribute during rendering is renderer-dependent. 
Some renderers which support transparency do not support a
transparent color.
.SH DEFAULTS
The default \f2DoTranspColor\fP is (\f2DcRGB\fP, (1.0, 1.0, 1.0)).
.SH "SEE ALSO"
.na
.nh
DoTranspIntens(3D), DoTranspOrientColor(3D), DoTranspOrientExp(3D),
DoTranspOrientIntens(3D), DoTranspOrientSwitch(3D), DoTranspSwitch(3D)
.hy
.ad
