.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTransformMatrix 3D  "Dore"
.SH NAME
DoTransformMatrix \- Create a transformation matrix geometric transformation object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTransformMatrix(matrix, comptype)
DtMatrix4x4 matrix;
DtCompType comptype;
.in  -.5i
.sp
FORTRAN:
.in +.5i
INTEGER*4 DOTMX(MATRIX, COMTYP)
REAL*8 MATRIX(4,4)
INTEGER*4 COMTYP
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTMX
.IX DoTransformMatrix
.I DoTransformMatrix
creates a transformation matrix geometric transformation object.
\f2DoTransformMatrix\fP is one of the geometric transformation objects
whose value is used to determine the current transformation matrix.
Unlike other geometric transformation objects that 
always preconcatenate their values with the current transformation
matrix so they apply first, \f2DoTransformMatrix\fP allows
the user to decide how it affects the current transformation
matrix.
.PP
The parameter \f2matrix\fP specifies an arbitrary modeling
transformation to be combined with the current transformation matrix.
The parameter \f2comptype\fP specifies the way \f2matrix\fP will be
combined with the current transformation matrix.
Possible values for \f2comptype\fP are:
.IP "\f2DcReplace\fP <\f2DCREPL\fP>"
\f2matrix\fP replaces the current transformation matrix.
.IP "\f2DcPreConcatenate\fP <\f2DCPREC\fP>"
\f2matrix\fP is preconcatenated to the current transformation
matrix; i.e., this transformation applies before any previous transformations.
.IP "\f2DcPostConcatenate\fP <\f2DCPSTC\fP>"
\f2matrix\fP is postconcatenated to the current transformation
matrix; i.e., this transformation applies after any previous transformations.
.PP
Note that Dore matrices are formed assuming that points are represented
as column vectors. See Chapter 7, \f2Dore Matrix Transformations\fP in
the  \f2Dore Reference Manual\fP for more information.
.PP
The parameter \f2matrix\fP can be an arbitrary 4x4 matrix, but
singular matrices (non-invertible) will cause fatal errors.
.SH "SEE ALSO"
.na
.nh
DoLookAtFrom(3D), DoRotate(3D), DoScale(3D), DoShear(3D),
DoTranslate(3D)
.ad
.hy
