.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTextureExtendUV 3D "Dore"
.SH NAME
DoTextureExtendUV \- Create a texture attribute object that controls texturing behavior beyond the boundary of a 2-dimensional texture
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTextureExtendUV(umode, vmode)
DtExtendMode umode;
DtExtendMode vmode;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOTXUV(UMODE, VMODE)
INTEGER*4 UMODE
INTEGER*4 VMODE
.in  -.5i
.fi 
.IX "DoTextureExtendUV"
.IX "DOTXUV"
.SH DESCRIPTION
.LP
\f2DoTextureExtendUV\fP creates a texture attribute object that
specifies what happens to the texture value when the \f2u\fP or \f2v\fP
coordinates of the primitive object extend beyond the limits of 
a 2-dimensional texture.
The parameter \f2umode\fP specifies the extension mode in the \f2u\fP 
direction and \f2vmode\fP specifies the extension mode in the \f2v\fP 
direction.
.PP
The possible values of \f2umode\fP and \f2vmode\fP are:
.IX "DcExtendNone"
.IX "DCXNON"
.IP "\f2DcExtendNone\fP <\f2DCXNON\fP>"
If the coordinate is outside the range [0..1] then no texture mapping
is done.
It is as if no texture map had been specified.
.IX "DcExtendBlack"
.IX "DCXBLK"
.IP "\f2DcExtendBlack\fP <\f2DCXBLK\fP>"
If the coordinate is outside the range [0..1] then the value computed by
the texture will be zero for every channel of data. 
.IX "DcExtendClamp"
.IX "DCXCLP"
.IP "\f2DcExtendClamp\fP <\f2DCXCLP\fP>"
If the coordinate is outside the range [0..1] then the value computed by 
the texture is the value at the nearest edge.
For example, if \f2u\fP is 3.5 then \f2u\fP is clamped to 1.0, 
thus the edge values are extended.
.IX "DcExtendRepeat"
.IX "DCXRP"
.IP "\f2DcExtendRepeat\fP <\f2DCXRP\fP>"
If the coordinate is outside the range [0..1] then the texture is
repeated.
Effectively, if the coordinate is \f2u\fP then the texture coordinate 
used for mapping would be (\f2u\fP - floor(\f2u\fP)).
.SH DEFAULTS
The default value for \f2DoTextureExtendUV\fP is \f2DcExtendNone\fP
<\f2DCXNON\fP> for both modes.
.SH SEE ALSO
.na
.nh
DoTextureExtendUVW(3D),
DoTextureMapDiffuseColor(3D),
DoTextureMapEnviron(3D),
DoTextureMapBump(3D),
DoTextureMapTranspIntens(3D)
.hy
.ad
\&
