.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoQuadMesh 3D  "Dore"
.SH NAME
DoQuadMesh \- Create a quadrilateral mesh primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoQuadMesh(colormodel, vertextype, 
	vertexcount, vertices, quadcount,
	quads, smoothflag)
DtColorModel colormodel;
DtVertexType vertextype;
DtInt vertexcount;
DtReal vertices[\|];
DtInt quadcount;
DtInt quads[\|];
DtFlag smoothflag;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOQUDM(COLMOD, VTXTYP, VTXCNT, 
		VTXS, QUDCNT, QUADS, 
			SMOOFL)
INTEGER*4 COLMOD
INTEGER*4 VTXTYP
INTEGER*4 VTXCNT
REAL*8 VTXS(*)
INTEGER*4 QUDCNT
INTEGER*4 QUADS(*)
INTEGER*4 SMOOFL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOQUDM
.IX DoQuadMesh
.I DoQuadMesh
creates a quadrilateral mesh primitive object that defines a collection of
quadrilaterals, normally interconnected.
.PP
With a quadrilateral mesh, you specify a collection of vertices
in space and connect the vertices into a collection of 
planar quadrilaterals, usually forming a connected surface.
.PP
The parameter \f2colormodel\fP specifies the color model used if the vertices
contain color information for shading purposes.
The parameter \f2vertextype\fP specifies the exact nature of the vertices.
For more information, refer to Chapter 6, \f2Dore Vertex Types\fP, in the 
\f2Dore Reference Manual\fP or to the \f2VertexTypes\fP on-line manual page.)
The parameter \f2vertexcount\fP specifies the total number of vertices in
the mesh.
The parameter \f2vertices\fP is an array of vertex data.
The parameter \f2quadcount\fP specifies the total number of quadrilaterals
in the mesh.  The parameter \f2quads\fP is a one-dimensional
array containing \f2quadcount\fP quadruplets of integers.
Each quadruplet is an ordered
list of mesh vertex numbers for the four coordinates of the quadrilateral.
.PP
If vertex normals are not provided,
the parameter \f2smoothflag\fP specifies that the vertex normal for shading
purposes will be the average of the geometric normals from a vertex's
adjacent surfaces.  This assumes that the quadrilateral mesh defines a 
smooth surface.
.PP
The geometric normal to each quadrilateral is calculated using the right-hand rule
(when the fingers of the right hand point in the order of the vertices,
the thumb points in the direction of the normal).  These geometric normal 
calculations require that all quadrilaterals be planar.  Dore
uses these normals for backface culling and flat shading.
.SH ERRORS
\f2DoQuadMesh\fP must be called with at least four vertices.
.PP 15
[WARNING - invalid parameter]
.PP
.I DoQuadMesh
will issue an warning if a zero vertex normal is calculated by Dore.
.PP 15
[WARNING - quad normals sum to 0 at vertex, check for back to back quads]
.PP
.I DoQuadMesh
will fail if an invalid vertex list pointer is specified.
.PP 15
[WARNING - value out of range]
.SH "SEE ALSO"
.na
.nh
DoQuadList(3D), VertexTypes(3D)
.hy
.ad
