.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoFrame 3D  "Dore"
.SH NAME
DoFrame \- Create a frame object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoFrame()
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOFR()
.in -.5i
.fi
.SH DESCRIPTION
.IX DOFR
.IX DoFrame
.I DoFrame
creates a new frame organizational object.
A frame is an object that describes an image to be displayed on a
device.  It defines a device independent 3D local
coordinate system within which one or more views can be
positioned.  
.PP
A frame can be displayed on 0 or more devices using the function
\f2DdSetFrame\fP <\f2DDSF\fP>.
The frame is mapped onto the largest right rectangular
volume that can fit within the device viewport such that the aspect ratio
in X and Y is preserved and that the Z extent of the frame is mapped to the
entire Z extent of the device.
When this mapping is performed, there may be extra white space
inside the device viewport.  The function \f2DfSetJust\fP
<\f2DFSJ\fP> is used to position this white space.
A frame's volume can be specified by \f2DfSetBoundary\fP
<\f2DFSB\fP> and queried with \f2DfInqBoundary\fP
<\f2DFQB\fP>.
.SH DEFAULTS
.LP
The frame extends from (0.0, 0.0, 0.0)
to (1.0, 1.0, 1.0).
.SH "SEE ALSO"
.na
.nh
DdSetFrame(3D), DfInqBoundary(3D), DfInqJust(3D),
DfSetBoundary(3D), DfSetJust(3D), DfSetJust(3D),
DfUpdate(3D)
.hy
.ad
