.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoEmissionFactor 3D  "Dore"
.SH NAME
DoEmissionFactor \- Create an emission factor primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoEmissionFactor(factor)
DtReal factor;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOEMIF(FACTOR)
REAL*8 FACTOR
.in -.5i
.fi
.SH DESCRIPTION
.IX DOEMIF
.IX DoEmissionFactor
.I DoEmissionFactor
creates an emission factor primitive attribute object.
Emissive primitive objects are used as light sources for radiosity calculations.
.PP
The parameter \f2factor\fP is a scale factor 
to apply to the light emitted by an object, as specified
with \f2DoEmissionColor <DOEMIC>\fP.
The emissivity of a surface is
enabled or disabled using \f2DoEmissionSwitch <DORADS>\fP.
.PP
.SH DEFAULTS
The default \f2DoEmissionFactor\fP value is 1.0.
.SH "SEE ALSO"
.na
.nh
DoEmissionColor(3D), 
DoEmissionSwitch(3D),
DoRadiositySwitch(3D)
.ad
.hy
