.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoClipSwitch 3D  "Dore"
.SH NAME
DoClipSwitch \- Create a primitive attribute object for enabling or disabling model clipping
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoClipSwitch(switchvalue)
DtSwitch switchvalue ;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOCS(SWVAL)
INTEGER*4 SWVAL 
.in -.5i
.fi
.SH DESCRIPTION
.IX DOCS
.IX DoClipSwitch
.I DoClipSwitch
creates a model clipping switch primitive attribute object.
Model clipping is used to cut away parts of a scene so that objects
that are normally obscured by the clipped objects can now be seen.
The \f2switchvalue\fP specifies whether or not subsequently
executed primitive objects will be clipped against the current
model clipping volume.
The values for \f2switchvalue\fP are:
.PP
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
Ignore modeling clipping volumes.
.IP "\f2DcOn\fP <\f2DCON\fP>"
Clip all subsequent primitive objects against the current model clipping
volume.
.SH DEFAULTS
The default \f2DoClipSwitch\fP is \f2DcOff\fP <\f2DCOFF\fP>.
.SH "SEE ALSO"
DoClipVol(3D)
