.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoAmbientIntens 3D  "Dore"
.SH NAME
DoAmbientIntens \- Create an ambient intensity primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoAmbientIntens(intensity)
DtReal intensity;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOAMBI(INTENS)
REAL*8 INTENS
.in -.5i
.fi
.SH DESCRIPTION
.IX DOAMBI
.IX DoAmbientIntens
\f2DoAmbientIntens\fP creates an ambient intensity primitive attribute
object.
The \f2intensity\fP parameter is used to specify the
intensity of a surface's ambient response to light from ambient
light sources in the environment.
The ambient intensity normally ranges from 0.0 to 1.0 signifying
the contribution of ambient component to the overall shade
of the object's surface.
.PP
The color of the ambient component of a surface is assumed to be the
same as for the diffuse component and is set by
\f2DoDiffuseColor\fP <\f2DODIFC\fP>.
\f2DoAmbientSwitch\fP <\f2DOAMBS\fP>
determines the applicability of ambient components to a surface.
.SH DEFAULTS
The default for \f2DoAmbientIntens\fP is 0.3.
.SH "SEE ALSO"
DoDiffuseColor(3D), DoAmbientSwitch(3D)
