.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DgSetElePtr 3D  "Dore"
.SH NAME
DgSetElePtr \- Set the group element pointer within the current group
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DgSetElePtr(element_ptr, position_orientation)
DtInt element_ptr;
DtRelPosition position_orientation;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DGSEP(ELEPTR, POSORT)
INTEGER*4 ELEPTR
INTEGER*4 POSORT
.in -.5i
.fi
.SH DESCRIPTION
.IX DGSEP
.IX DgSetElePtr
.I DgSetElePtr
sets the group element pointer to the location \f2element_ptr\fP, 
relative to position orientation \f2position_orientation\fP,
in the currently open group.
.PP
Each group has an element pointer that identifies the current
editing position within the group.  The element pointer points between
elements of a group.  A value of 0 indicates that the element pointer
is pointing before the first element in the group.  A value of \f2n\fP,
where \f2n\fP is the current size of the group, indicates that the element
pointer is pointing after the last element in the group. 
.PP
The \f2position_orientation\fP parameter takes one of the following values:
.IP "\f2DcBeginning\fP <\f2DCBEG\fP>"
The element pointer is positioned relative to the beginning of the group.
.IP "\f2DcEnd\fP <\f2DCEND\fP>"
The element pointer is positioned relative to the end of the group.
.IP "\f2DcCurrent\fP <\f2DCCUR\fP>"
The element pointer is positioned relative
to the element pointer's current position.
.SH ERRORS
.I DgSetElePtr
will fail if no group is currently open.
.TP 15
[WARNING - a group is not currently open]
.SH "SEE ALSO"
DgInqElePtr(3D), DgSetElePtrRelLabel(3D)
