.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DgAddObjToGroup 3D  "Dore"
.SH NAME
DgAddObjToGroup \- Add an object to a specified group
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DgAddObjToGroup(group,object)
DtObject group;
DtObject object;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DGAOG(GROUP,OBJECT)
INTEGER*4 GROUP
INTEGER*4 OBJECT
.in -.5i
.fi
.SH DESCRIPTION
.IX DGAOG
.IX DgAddObjToGroup
\f2DgAddObjToGroup\fP adds an object, \f2object\fP, to the specified
group, \f2group\fP.  The object is inserted into the group at the
position indicated by the element pointer, and the element pointer moves
forward one position so that it points after the object just
inserted.  Any objects that follow the element pointer also move
forward.
.PP
The most common way to call the \f2DgAddObjToGroup\fP function is:
.nf

	DgAddObjToGroup(group,DoXXXX());

.fi
where the \f2DoXXXX()\fP call creates and returns an object of type
XXXX.  The object is added to the designated group through the
\f2DgAddObjToGroup\fP call.  One can also create an object
through a separate call to a \f2DoXXXX\fP routine and then call the
\f2DgAddObjToGroup\fP routine with the object directly:
.nf

	object = DoXXXX();
	DsHoldObj(object);
	DgAddObjToGroup(group,object);

.fi
One may also call this function in the following manner:
.nf

	DgAddObjToGroup(group,DsHoldObj(object=DoXXXX()));

.fi
This causes \f2object\fP to take the value of the
newly created object and places the object in the specified
group.
.PP
The call to \f2DsHoldObj\fP is needed only if the user also wants to
use the created object for other purposes.  Any object held with
\f2DsHoldObj\fP will not be deleted. The application program is always
responsible for reclaiming storage from held objects that
become obsolete.
.SH ERRORS
.I DgAddObjToGroup
will fail if called with an invalid group.
.TP 15
[WARNING - invalid group handle]
.PP
.I DgAddObjToGroup
will fail if called with an invalid object.
.TP 15
[WARNING - invalid or deleted object]
.SH "SEE ALSO"
.na
.nh
DgAddObj(3D), DgInqOpen(3D), DgOpen(3D), DoGroup(3D), 
DoInLineGroup(3D), DsHoldObj(3D)
.ad
.hy
