.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdSetOptions 3D  "Dore"
.SH NAME
DdSetOptions \- Set driver specific values of a device 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DdSetOptions(device, argstring)
DtObject device;
DtPtr argstring;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DDSO(DEVICE, ARGSTR, LARG)
INTEGER*4 DEVICE, LARG
CHARACTER*LARG ARGSTR
.in -.5i
.fi
.SH DESCRIPTION
.IX DDSO
.IX DdSetOptions
.I DdSetOptions
modifies driver specific attributes of a Dore device that has
previously been created with \f2DoDevice\fP <\f2DOD\fP>.
The attributes that may be changed using \f2DdSetOptions\fP depend
on the specific device driver.
For example, a driver may have an option to modify the method
used to compute the transparency of a primitive object.
.PP
The parameter \f2device\fP is an object handle to the device previously created with \f2DoDevice\fP <\f2DOD\fP>.
.PP
The parameter \f2argstring\fP is a string 
with embedded device options.
Options specify the attribute and the value to be assigned.
An option takes one of the following forms:
.IP "-optionflag \f2optionvalue\fP"
for options requiring values.
.IP "-optionflag"
for boolean flags where the presence of "-optionflag" means
\f2true\fP.
.PP
Numeric option values must be specified by their decimal \s-1ASCII\s+1
representations.
Multiple options within \f2argstring\fP must be separated by at least one
blank, tab, or comma, though all legal options may occur in any order within
\f2argstring\fP.  If the same option is specified more than once in
\f2argstring\fP, then only the last value for that option is used.  The legal
options in \f2argstring\fP depend upon the \f2device\fP parameter.
.PP
For information on   
particular device, see your \f2Dore System Guide\fP.
.SH "FORTRAN SPECIFIC"
.PP
\f2ARGSTR\fP is a string \f2LARG\fP bytes long containing
device options.
.SH ERRORS
.I DdSetOptions
will fail if the device handle is invalid.
.TP 15
[WARNING - invalid device handle]
.SH "SEE ALSO"
.na
.nh
DoDevice(3D)
.ad
.hy
\&
