/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

//
// Create a X/Xt/IM window
//


#include "cppArgs.h"

#include <stdio.h>
#include <gl/get.h>

#include "misCube.h"
#include "hciTlutWindow.H"


TlutWindow::TlutWindow(const char* name, Widget parent, GLWindowType wt,
		       MainWindow *_mainWindow, VRState *_state)
  : GLXWindow(name, parent, wt, 200, 200),
    mainWindow(_mainWindow), state(_state)
{
}


TlutWindow::~TlutWindow()
{
}


const char* TlutWindow::className()
{
  return( "TlutWindow" );
}


void TlutWindow::Init(Widget widget, XtPointer caData)
{
  GLXWindow::Init(widget, caData);
}


void TlutWindow::Input(Widget, XtPointer)
{
}


void TlutWindow::Redraw(Widget, XtPointer)
{
  Focus();

#ifdef VR_IRISGL
  clear();
#endif

#ifdef VR_OPENGL
  glClear(GL_COLOR_BUFFER_BIT);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0.0, 1.1, 0.0, 1.1, -1.0, 1.0);

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glTranslatef(0.05, 0.05, 0.0);

  int i, curVol = state->view->curVol;
  VRVolumeData *vd = state->volumeData[curVol];
  float graphScale = 0.8;
  float tlutScale = 1.0 - graphScale;

  // Draw the graph
  glPushMatrix();
  glTranslatef(0.0, tlutScale, 0.0);
  glScalef(1.0, graphScale, 1.0);

  // Draw background color
  glColor4f(COLOR_TO_OGL(state->world->backColor));

  glBegin(GL_QUADS);
  glVertex2f(0.0, 0.0);
  glVertex2f(0.0, 1.0);
  glVertex2f(1.0, 1.0);
  glVertex2f(1.0, 0.0);
  glEnd();
    
  // Draw the graph bounding box
  glColor3f(0.6, 0.6, 0.6);

  glBegin(GL_LINE_LOOP);
  glVertex2f(0.0, 0.0);
  glVertex2f(0.0, 1.0);
  glVertex2f(1.0, 1.0);
  glVertex2f(1.0, 0.0);
  glEnd();

  float tY1 = 0.1;
  float tY2 = 0.9;
  float tX1 = graphScale*tY1/aspect;
  float tX2 = 1.0 - tX1;
  float tH = tY2 - tY1;
  float tW = tX2 - tX1;

  // Draw the tick marks
  glBegin(GL_LINES);

  int ticks=16;

  for (i=0; i<=ticks; i++) {
    float f = ((float) i) / ticks;
    float l = 1.0;
    int t = ticks;
    while ((i % t) != 0) {
      t /= 2;
      l *= 0.7;
    }
    glVertex2f(0.0, tY1+f*tH);
    glVertex2f(tX1*l, tY1+f*tH);
    glVertex2f(1.0, tY1+f*tH);
    glVertex2f(1.0-tX1*l, tY1+f*tH);
    glVertex2f(tX1+f*tW, 0.0);
    glVertex2f(tX1+f*tW, tY1*l);
    glVertex2f(tX1+f*tW, 1.0);
    glVertex2f(tX1+f*tW, 1.0-tY1*l);
  }

  glEnd();

  // Draw graph
  glTranslatef(tX1, tY1, 0.0);
  glScalef(tW, tH, 1.0);

  if (curVol != -1) {

    GLfloat color[4][3] = { { 1.0, 0.0, 0.0 }, { 0.0, 1.0, 0.0 },
			    { 0.0, 0.0, 1.0 }, { 1.0, 1.0, 1.0 } };

    glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);
    glEnable(GL_BLEND);

    glEnable(GL_LINE_SMOOTH);

    // Draw the histogram in dark grey
    if (vd->histValid) {
      glColor4f(0.3, 0.3, 0.3, 1.0);
      glBegin(GL_LINE_STRIP);
      for (i=0; i<256; i++) {
	glVertex2f(i/255.0, vd->hist[i]);
	if (state->view->debug == 8) {
	  printf("%4.2f ", vd->hist[i]);
	  if ((i % 8) == 7)
	    printf("\n");
	}
      }
      glEnd();
    }

    switch (state->mode->sliderMode) {

      // Draw the transfer function
    case 0:
      glColor3fv(color[3]);
      glBegin(GL_LINE_STRIP);
      for (i=0; i<256; i++)
	glVertex2f(i/255.0, vd->tfunc[i]);
      glEnd();
      break;

      // Draw the colormap and alphamap
    case 1:
      for (int c=0; c<4; c++) {
	glColor3fv(color[c]);
	glBegin(GL_LINE_STRIP);
	for (i=0; i<256; i++)
	  glVertex2f(i/255.0, vd->camap[i*4+c]);
	glEnd();
      }
      break;

      // Draw the lookup table
    case 2:
      for (c=0; c<4; c++) {
	glColor3fv(color[c]);
	glBegin(GL_LINE_STRIP);
	for (i=0; i<256; i++)
	  glVertex2f(i/255.0, vd->tlut[i*4+c]);
	glEnd();
      }
      break;
    }

    glDisable(GL_BLEND);
    glDisable(GL_LINE_SMOOTH);
  }

  glPopMatrix();

  // Draw the tlut ramp
  glPushMatrix();
  glScalef(1.0, tlutScale, 1.0);
  glTranslatef(tX1, tY1, 0.0);
  glScalef(tW, tH, 1.0);

  // Draw background color
  glColor4f(COLOR_TO_OGL(state->world->backColor));

  glBegin(GL_QUADS);
  glVertex2f(0.0, 0.0);
  glVertex2f(0.0, 1.0);
  glVertex2f(1.0, 1.0);
  glVertex2f(1.0, 0.0);
  glEnd();
    
  // Draw tlut ramps
  if (curVol != -1) {

    // Draw top of ramp
    glBegin(GL_QUAD_STRIP);
    for (i=0; i<256; i++) {
      glColor3fv(&vd->tlut[i*4]);
      glVertex2f(i/255.0, 1.0);
      glVertex2f(i/255.0, 0.5);
    }
    glEnd();

    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);

    // Draw bottom of ramp
    glBegin(GL_QUAD_STRIP);
    for (i=0; i<256; i++) {
      glColor4fv(&vd->tlut[i*4]);
      glVertex2f(i/255.0, 0.5);
      glVertex2f(i/255.0, 0.0);
    }
    glEnd();

    glDisable(GL_BLEND);
  }

  // Draw the tlut ramp bounding box
  glColor3f(0.6, 0.6, 0.6);

  glBegin(GL_LINE_LOOP);
  glVertex2f(0.0, 0.0);
  glVertex2f(0.0, 1.0);
  glVertex2f(1.0, 1.0);
  glVertex2f(1.0, 0.0);
  glEnd();

  glPopMatrix();
#endif

#ifdef VR_IRISGL
  swapbuffers();
#endif

#ifdef VR_OPENGL
  glXSwapBuffers(state->view->disp, window);
#endif
}



void TlutWindow::Resize(Widget, XtPointer caData)
{
#ifdef VR_IRISGL
  GlxDrawCallbackStruct *resize = (GlxDrawCallbackStruct*) caData;
#endif

#ifdef VR_OPENGL
  GLwDrawingAreaCallbackStruct *resize = (GLwDrawingAreaCallbackStruct*) caData;
#endif

  width = resize->width;
  height = resize->height;
  aspect = ((float) width) / height;

  Redraw();
}


void TlutWindow::HandleKey(char key, int /*viaKeystroke*/)
{
  switch (key) {

    // Ignore tab releases that come through
  case '\t':
    break;
  }
}
