/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/


#include "cppArgs.h"

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#include "genVolRen.h"
#include "genByteCompile.H"
#include "misBrickInfo.h"


#ifdef VR_INTERLEAVE
void WriteCompiledBricks( VRState*, int fd, unsigned long *buf,
			  int x, int y, int z, int nc,
			  Brick **b, int nBricks )
{
  int ret;
  BrickInfo brickInfo;

  // Record the information about this file and the bricks in it
  brickInfo.nBricks   = nBricks;
  brickInfo.brickOff  = sizeof(BrickInfo);
  brickInfo.brickLen  = sizeof(Brick);
  brickInfo.dataOff   = sizeof(BrickInfo) + nBricks*sizeof(Brick);
  brickInfo.dataLen   = x * y * z * nc;

  // Compute the total size of the file needed
  int len = sizeof(BrickInfo) + nBricks*sizeof(Brick) + brickInfo.dataLen;

  // Mmap the file into memory
  char *mapptr = (char*) mmap( 0, len, PROT_WRITE, MAP_SHARED|MAP_AUTOGROW, fd, (off_t)0 );
  if (mapptr == (void*)-1) {
    fprintf( stderr, "Couldn't mmap file!\n");
    fprintf( stderr, "volren: %s\n", strerror(oserror()) );
    exit( EXIT_FAILURE );
  }

  // Copy the information into the mmap'ed memory object
  char *ptr = mapptr;

  memcpy(ptr, &brickInfo, sizeof(BrickInfo));
  ptr += sizeof(brickInfo);

  for (int i=0; i<nBricks; i++) {

    memcpy(ptr, b[i], sizeof(Brick));
    ptr += sizeof(Brick);
  }

  memcpy(ptr, buf, brickInfo.dataLen);

  // Unmmap the brick
  ret = munmap(mapptr, len);
  if (ret == -1) {
    fprintf( stderr, "Couldn't munmap file!\n");
    fprintf( stderr, "volren: %s\n", strerror(oserror()) );
    exit( EXIT_FAILURE );
  }
}
#endif


#ifdef VR_INTERLEAVE
void ReadCompiledBricks( VRState *state, int fd, unsigned long *buf,
			 int x, int y, int z, int nc,
			 Brick **, int nBricks )
{
  char *mapptr;
  int ret;
  BrickInfo *brickInfo;

  // Mmap the compiled brick file header
  mapptr = (char*) mmap( 0, sizeof(BrickInfo), PROT_READ, MAP_SHARED, fd, (off_t)0 );
  if (mapptr == (void*)-1) {
    fprintf( stderr, "Couldn't mmap file!\n");
    fprintf( stderr, "volren: %s\n", strerror(oserror()) );
    exit( EXIT_FAILURE );
  }

  brickInfo = (BrickInfo*) mapptr;

  if (brickInfo->brickOff != sizeof(BrickInfo)) {
    fprintf(stderr, "Brick information size does not match in compiled brick file!\n");
    exit( EXIT_FAILURE );
  }

  if (brickInfo->nBricks != nBricks) {
    if (state->world->verbose) {
      fprintf(stderr, "Brick count numbers do not match in compiled brick file!\n");
      fprintf(stderr, "Attempting to continue anyway!\n");
    }
  }

  if (brickInfo->brickLen != sizeof(Brick)) {
    if (state->world->verbose) {
      fprintf(stderr, "Brick structure size does not match in compiled brick file!\n");
      fprintf(stderr, "Attempting to continue anyway!\n");
    }
  }

  if (brickInfo->dataLen != (x*y*z*nc)) {
    fprintf(stderr, "Brick data size does not match in compiled brick file!\n");
    exit( EXIT_FAILURE );
  }

  int len = brickInfo->dataOff + brickInfo->dataLen;

  // Unmmap the header
  ret = munmap(mapptr, sizeof(BrickInfo));
  if (ret == -1) {
    fprintf( stderr, "Couldn't munmap file!\n");
    fprintf( stderr, "volren: %s\n", strerror(oserror()) );
    exit( EXIT_FAILURE );
  }

  // Mmap the entire compiled brick file
  mapptr = (char*) mmap( 0, len, PROT_READ, MAP_SHARED, fd, (off_t)0 );
  if (mapptr == (void*)-1) {
    fprintf( stderr, "Couldn't mmap file!\n");
    fprintf( stderr, "volren: %s\n", strerror(oserror()) );
    exit( EXIT_FAILURE );
  }

  brickInfo = (BrickInfo*) mapptr;

  /*
  char *ptr = mapptr;
  ptr += sizeof(BrickInfo);

  for (int i=0; i<nBricks; i++) {

    brick = (Brick*) ptr;
    memcpy(b[i], brick, sizeof(Brick));
    ptr += sizeof(Brick);
  }
  */

  memcpy(buf, mapptr+brickInfo->dataOff, brickInfo->dataLen);

  // Unmmap the brick
  ret = munmap(mapptr, len);
  if (ret == -1) {
    fprintf( stderr, "Couldn't munmap file!\n");
    fprintf( stderr, "volren: %s\n", strerror(oserror()) );
    exit( EXIT_FAILURE );
  }
}
#endif
