/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/


#include "cppArgs.h"

#include <string.h>

#include "volClipPlanes.H"
#include "misCoord.h"
#include "misMatrix.h"


/*
 * Determine three independent points on the plane specified by n and d.
 * The actual plane is:
 *
 * n.x * x + n.y * y + n.z * z + d = 0
 *
 * where (x,y,z) are the free variables.
 */
void FindPointsOnPlane( coord *n, float d, coord *p1, coord *p2, coord *p3 )
{
  coord v1, v2;

  /* The first point is the projection of the origin along the normal into the plane */
  p1->x = n->x * (-d);
  p1->y = n->y * (-d);
  p1->z = n->z * (-d);

  /* Find a vector indenpendent to the normal */
  if ((fabs(n->x) < 0.01) && (fabs(n->y) < 0.01)) {

    /* Normal points mostly towards z, choose x axis */
    v1.x = 1.0 * ((n->z < 0) ? -1.0 : 1.0);
    v1.y = 0.0;
    v1.z = 0.0;

  } else {

    /* Normal points away from z, rotate normal about z */
    v1.x =  n->y;
    v1.y = -n->x;
    v1.z =  n->z;
  }

  /* Cross the normal and indepent vector to get an orthogonal vector */
  coord_cross_product( *n, v1, v2 );

  /* Cross the normal and the orthogonal vector to get a second one */
  coord_cross_product( *n, v2, v1 );

  /* The second and third points are just the first offset by the 
     computed orthogonal vectors */
  coord_add( *p1, v1, *p2 );
  coord_add( *p1, v2, *p3 );
}


void DefineClipPlanes( VRState *state, float *ucp )
{
  int i, j;
  coord p1, p2, p3, n;
  float w1, w2, w3, d;

#ifdef VR_IRISGL
  float cp[MAX_PLANES][4];
#endif

#ifdef VR_OPENGL
  GLdouble cp[MAX_PLANES][4];
#endif

  for (i=0; i<state->planeData->nPlanes; i++)
  {
    n.x = state->planeData->plane[i].a;
    n.y = state->planeData->plane[i].b;
    n.z = state->planeData->plane[i].c;

    /*
     * Transform the plane normal by the world rotation
     */
    coord_transform( n, state->view->InvRotMat, n );

    d = state->planeData->plane[i].d;

    /*
     * Define the clip plane
     */
    cp[i][0] = n.x;
    cp[i][1] = n.y;
    cp[i][2] = n.z;
    cp[i][3] = d;

    if (state->view->debug == 2)
      printf("Defining plane #%d as [%8.4f,%8.4f,%8.4f,%8.4f]\n", i,
	     cp[i][0], cp[i][1], cp[i][2], cp[i][3]);

#ifdef VR_IRISGL
    clipplane( i, CP_DEFINE, cp[i] );
#endif

#ifdef VR_OPENGL
    glClipPlane(GL_CLIP_PLANE0 + i, cp[i]);
#endif

    /*
     * Now we want to compute whether this plane is facing towards
     * or away from us.  The method will be to create two vectors
     * on the slice plane (three points) and transform them by the
     * model and projection matrices.  By taking the cross product
     * of the two transformed vectors and considering its Z-value
     * we can determine the plane\'s facing.
     */

    /*
     * WARNING!
     *
     * This method of transforming the normal
     * has some stability problems, but it seems
     * to work consistently for me.  It should
     * probably be investigated further though.
     */

    /*
     * Find three independent points on the plane
     */
    n.x = state->planeData->plane[i].a;
    n.y = state->planeData->plane[i].b;
    n.z = state->planeData->plane[i].c;
    FindPointsOnPlane( &n, d, &p1, &p2, &p3 );

    if ((state->view->debug == 7) && (i == 0)) {
      printf("Defining clip plane #%d\n", i);
      printf("Vector 1 - (%7.4f, %7.4f, %7.4f)\n", p2.x-p1.x, p2.y-p1.y, p2.z-p1.z);
      printf("Vector 2 - (%7.4f, %7.4f, %7.4f)\n", p3.x-p1.x, p3.y-p1.y, p3.z-p1.z);
    }

    /*
     * Transform the points and do the homogenous divide
     */
    coord_transw( p1, state->view->WTSMat, w1 );
    coord_transw( p2, state->view->WTSMat, w2 );
    coord_transw( p3, state->view->WTSMat, w3 );
    coord_transform( p1, state->view->WTSMat, p1 );
    coord_transform( p2, state->view->WTSMat, p2 );
    coord_transform( p3, state->view->WTSMat, p3 );
    coord_div( p1, w1, p1 );
    coord_div( p2, w2, p2 );
    coord_div( p3, w3, p3 );

    /*
     * Create two vectors from the three points
     */
    coord_sub( p2, p1, p2 );
    coord_sub( p3, p1, p3 );

    /*
     * The final (important) vector is the cross product of
     * the two transformed vectors.
     */
    coord_cross_product( p2, p3, p1 );

    if ((state->view->debug == 7) && (i == 0)) {
      printf("Vector 1 - (%7.4f, %7.4f, %7.4f)\n", p2.x, p2.y, p2.z);
      printf("Vector 2 - (%7.4f, %7.4f, %7.4f)\n", p3.x, p3.y, p3.z);
      printf("Transformed vector - (%7.4f, %7.4f, %7.4f)\n", p1.x, p1.y, p1.z);
    }

    state->planeData->plane[i].facing = (p1.z < 0) ? FACING_AWAY : FACING_TOWARDS;
  }

  if (ucp)
    for (i=0; i<state->planeData->nPlanes; i++)
      for (j=0; j<4; j++)
	ucp[i*4+j] = (float) cp[i][j];
}


void EnableActiveClipPlanes( VRState *state, int except )
{
  for (int i=0; i<state->planeData->nPlanes; i++)
    if ( state->planeData->plane[i].active && (i != except) ) {

#ifdef VR_IRISGL
      clipplane( i, CP_ON, 0 );
#endif

#ifdef VR_OPENGL
      glEnable(GL_CLIP_PLANE0 + i);
#endif

    } else {

#ifdef VR_IRISGL
      clipplane( i, CP_OFF, 0 );
#endif

#ifdef VR_OPENGL
      glDisable(GL_CLIP_PLANE0 + i);
#endif
    }
}


void DisableAllClipPlanes( VRState *state )
{
  for (int i=0; i<state->planeData->nPlanes; i++) {

#ifdef VR_IRISGL
    clipplane( i, CP_OFF, 0 );
#endif

#ifdef VR_OPENGL
    glDisable(GL_CLIP_PLANE0 + i);
#endif
  }
}
