/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

//
// Create a GLX/IM/Xt window
//


#include "cppArgs.h"

#include <stdio.h>
#include <gl/get.h>

#include "hciRenderWindow.H"
#include "hciMainWindow.H"
#include "hciUpdateScreen.h"
#include "hciHandlers.h"
#include "misComputeNormals.H"
// #include "misBhash.h"
// #include "misPchip.h"
#include "misTransferFunc.h"
#include "misSnapScreen.H"
#include "volInit.h"
#include "volGeomUtils.h"
#include "genSetup.H"
#include "genWindowMaint.h"
#include "genSignal.H"


RenderWindow::RenderWindow(const char* name, Widget parent, GLWindowType wt,
			   MainWindow *_mainWindow, VRState *_state)
  : GLXWindow(name, parent, wt, _state->view->width, _state->view->height),
    mainWindow(_mainWindow), state(_state)
{
  // Initialize the workproc ID and button members
  workprocID = 0;
  button = 0;
}


RenderWindow::~RenderWindow()
{
}


const char* RenderWindow::className()
{
  return( "RenderWindow" );
}


#ifdef VR_IRISGL
static float mdl[] = { AMBIENT, 0.4, 0.4, 0.4, LOCALVIEWER, 0.0,
		       TWOSIDE, 1.0, LMNULL };

static float lgt[] = { LCOLOR, 1.0, 1.0, 1.0, POSITION, 0.5, 0.5, 1.5, 0.0, LMNULL };

static float sfmat[] = { AMBIENT, 0.2, 0.2, 0.2, DIFFUSE, 0.0, 0.3, 0.2,
			 SPECULAR, 0.5, 0.5, 0.5, SHININESS, 30, LMNULL };

static float sbmat[] = { AMBIENT, 0.2, 0.2, 0.2, DIFFUSE, 0.2, 0.0, 0.3,
			 SPECULAR, 0.5, 0.5, 0.5, SHININESS, 30, LMNULL };

static float amat[] = { AMBIENT, 0.2, 0.2, 0.2, DIFFUSE, 0.0, 0.2, 0.3,
			SPECULAR, 0.5, 0.5, 0.5, SHININESS, 30, LMNULL };

static float efmat[] = { AMBIENT, 0.2, 0.2, 0.2, DIFFUSE, 0.3, 0.2, 0.0,
			 SPECULAR, 0.5, 0.5, 0.5, SHININESS, 30, LMNULL };

static float ebmat[] = { AMBIENT, 0.2, 0.2, 0.2, DIFFUSE, 0.0, 0.3, 0.2,
			 SPECULAR, 0.5, 0.5, 0.5, SHININESS, 30, LMNULL };
#endif

#ifdef VR_OPENGL
static GLfloat mdl_ambient[] = { 0.4, 0.4, 0.4, 1.0 };
static GLfloat mdl_local[] = { 0.0 };
static GLfloat mdl_twoside[] = { 1.0 };

static GLfloat lgt_diffuse[] = { 1.0, 1.0, 1.0, 1.0 };
static GLfloat lgt_position[] = { 0.5, 0.5, 1.5, 0.0 };

static GLfloat mat_ambient[] = { 0.2, 0.2, 0.2, 1.0 };
static GLfloat mat_specular[] = { 0.5, 0.5, 0.5, 1.0 };
static GLfloat mat_shininess[] = { 30.0 };

static GLfloat sfmat_diffuse[] = { 0.0, 0.3, 0.2, 1.0 };
static GLfloat sbmat_diffuse[] = { 0.2, 0.0, 0.3, 1.0 };

static GLfloat efmat_diffuse[] = { 0.3, 0.2, 0.0, 1.0 };
static GLfloat ebmat_diffuse[] = { 0.0, 0.3, 0.2, 1.0 };
#endif


void RenderWindow::Init(Widget widget, XtPointer caData)
{
  GLXWindow::Init(widget, caData);

  state->view->wind = window;

  state->view->width = width;
  state->view->height = height;
  state->view->aspect = aspect;

#ifdef VR_OPENGL
  state->view->context = context;
#endif

  FocusView(state);

  glDisable(GL_DITHER);

  if ( !state->view->boundLights ) {

#ifdef VR_IRISGL
    lmdef(DEFLMODEL, 1, 4, mdl);
    lmdef(DEFLIGHT, 1, 3, lgt);
    lmdef(DEFMATERIAL, 1, 5, sfmat);
    lmdef(DEFMATERIAL, 2, 5, sbmat);
    lmdef(DEFMATERIAL, 3, 5, amat);
    lmdef(DEFMATERIAL, 4, 5, efmat);
    lmdef(DEFMATERIAL, 5, 5, ebmat);

    lmbind(LIGHT0, 1);
#endif

#ifdef VR_OPENGL
    glLightModelfv(GL_LIGHT_MODEL_AMBIENT,      mdl_ambient);
    glLightModelfv(GL_LIGHT_MODEL_LOCAL_VIEWER, mdl_local);
    glLightModelfv(GL_LIGHT_MODEL_TWO_SIDE,     mdl_twoside);

    glLightfv(GL_LIGHT0, GL_POSITION, lgt_position);
    glLightfv(GL_LIGHT0, GL_DIFFUSE,  lgt_diffuse);
    glEnable(GL_LIGHT0);

    glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT,   mat_ambient);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,  mat_specular);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, mat_shininess);

    glMaterialfv(GL_FRONT, GL_DIFFUSE, sfmat_diffuse);
    glMaterialfv(GL_BACK, GL_DIFFUSE, sbmat_diffuse);

    glMaterialfv(GL_FRONT, GL_DIFFUSE, efmat_diffuse);
    glMaterialfv(GL_BACK, GL_DIFFUSE, ebmat_diffuse);

    glEnable(GL_NORMALIZE);
#endif

    state->view->boundLights = TRUE;
  }
}


void RenderWindow::Input(Widget, XtPointer caData)
{
  static int noSurfaceBeforeMove = FALSE;
  int modbutton;
  int i, x, y;
  char s[100];
  static char last='\0';

#ifdef VR_IRISGL
  GlxDrawCallbackStruct *input = (GlxDrawCallbackStruct*) caData;
#endif

#ifdef VR_OPENGL
  GLwDrawingAreaCallbackStruct *input = (GLwDrawingAreaCallbackStruct*) caData;
#endif

  XButtonEvent    *button_event;
  XKeyEvent       *key_event;

  button_event = (XButtonEvent*) (input->event);
  key_event    = (XKeyEvent*)    (input->event);

  // Set   the modbutton value to 1-9
  // 1-3   are normal buttons
  // 4-6   are same buttons with shift modifier
  // 7-9   are same buttons with ctrl modifier
  // 9-12  are same buttons with ctrl & shift modifiers
  if (input->event->type & (ButtonPressMask | ButtonReleaseMask | PointerMotionMask))
  {
    if ((button_event->state & ShiftMask) && (button_event->state & ControlMask))
      modbutton = button_event->button + 9;
    else if (button_event->state & ShiftMask)
       modbutton = button_event->button + 3;
    else if (button_event->state & ControlMask)
       modbutton = button_event->button + 6;
    else
       modbutton = button_event->button;

    x = button_event->x;
    y = state->view->height - button_event->y - 1;
  }

  switch (input->event->type) {
  case KeyPress:
    i = XLookupString(key_event, s, 100, NULL, NULL);
    if ( i ) {
      HandleKey(s[0], True);
      RedrawWindows();
      last = s[0];
    }
    break;

    // We do this craziness with catching key releases because SGI keyboard
    // 'ESC' keys do not generate key press actions!  Only handle the key
    // release if it isn't followed by a key press of the same key.
  case KeyRelease:
    i = XLookupString(key_event, s, 100, NULL, NULL);
    if ( i && (s[0] != last) ) {
      HandleKey(s[0], True);
      RedrawWindows();
      last = '\0';
    }
    break;

  case ButtonPress:
    if (button != 0)		// Do not allow multiple simultaneous button presses
      break;

    button = modbutton;
    state->view->autoSpin = False; // Turn off auto spinning

    switch (button) {
    case 1:
      TrackMovingVolume(state, x, y, TRACK_START, -1);
      break;

    case 2:
      if (state->view->curSurf != -1)
	match = PointMatches(state, state->pointData[state->view->curSurf], x, y);
      else 
	if (state->mode->pointsMode) {
	  match = PointMatches(state, NULL, x, y);
	  noSurfaceBeforeMove = TRUE;
	} else
	  match = -1;

      if (match != -1) {

	TrackMovingSurface(state, x, y, match, TRACK_START);

      }	else {

	if (!state->mode->sliceMode) {
	  NotifyError("You cannot pick a point without clip planes enabled!", FALSE);
	  button = 0;
	  break;
	}

	TrackPickingPlanes(state, x, y, TRACK_START);
      }
      break;

    case 3:
      if (!state->mode->sliceMode) {
	NotifyError("You cannot rotate a clip plane without clip planes enabled!", FALSE);
	button = 0;
	break;
      }
      if (state->view->curPlane < 0) {
	NotifyError("You cannot rotate a clip plane without a clip plane selected!", FALSE);
	button = 0;
	break;
      }
      TrackMovingSlicePlane(state, x, y, TRACK_START);
      break;

    case 4:
      TrackZoomingVolume(state, x, y, TRACK_START, -1);
      break;

    case 5:
      if (!state->mode->sliceMode) {
	NotifyError("You cannot pick a point without clip planes enabled!", FALSE);
	button = 0;
	break;
      }
      if (state->view->curSurf == -1) {
	NotifyError("You cannot pick a point without a surface selected!", FALSE);
	button = 0;
	break;
      }
      TrackPickingPoints(state, x, y, TRACK_START);
      break;

    case 6:
      if (!state->mode->sliceMode) {
	NotifyError("You cannot translate a clip plane without clip planes enabled!", FALSE);
	button = 0;
	break;
      }
      if (state->view->curPlane < 0) {
	NotifyError("You cannot translate a clip plane without a clip plane selected!", FALSE);
	button = 0;
	break;
      }
      TrackDrivingSlicePlane(state, x, y, TRACK_START);
      break;

    case 7:
      if (state->view->curVol == -1) {
	NotifyError("You cannot rotate a volume without a volume selected!", FALSE);
	button = 0;
	break;
      }
      TrackMovingVolume(state, x, y, TRACK_START, state->view->curVol);
      break;

    case 8:
      if (state->view->curVol == -1) {
	NotifyError("You cannot translate a volume without a volume selected!", FALSE);
	button = 0;
	break;
      }
      TrackMovingXYVolume(state, x, y, TRACK_START);
      break;

    case 9:
      if (state->view->curVol == -1) {
	NotifyError("You cannot translate a volume without a volume selected!", FALSE);
	button = 0;
	break;
      }
      TrackMovingZVolume(state, x, y, TRACK_START);
      break;

    case 10:
      if (state->view->curVol == -1) {
	NotifyError("You cannot zoom a volume without a volume selected!", FALSE);
	button = 0;
	break;
      }
      TrackZoomingVolume(state, x, y, TRACK_START, state->view->curVol);
      break;

    case 11:
      TrackMovingPhantomEye(state, x, y, TRACK_START);
      break;

    case 12:
      TrackResettingPhantomEye(state, x, y, TRACK_START);
      break;

    default:
      XBell(theApplication->display(), 50);
      button = 0;
      break;
    }

    if (button != 0)
      BeginInteractiveMode( state );
    break;

  case MotionNotify:
    switch (button) {
    case 1:
      TrackMovingVolume(state, x, y, TRACK, -1);
      break;

    case 2:
      if (match == -1)
	TrackPickingPlanes(state, x, y, TRACK);
      else
	TrackMovingSurface(state, x, y, match, TRACK);
      break;

    case 3:
      TrackMovingSlicePlane(state, x, y, TRACK);
      break;

    case 4:
      TrackZoomingVolume(state, x, y, TRACK, -1);
      break;

    case 5:
      TrackPickingPoints(state, x, y, TRACK);
      break;

    case 6:
      TrackDrivingSlicePlane(state, x, y, TRACK);
      break;

    case 7:
      TrackMovingVolume(state, x, y, TRACK, state->view->curVol);
      break;

    case 8:
      TrackMovingXYVolume(state, x, y, TRACK);
      break;

    case 9:
      TrackMovingZVolume(state, x, y, TRACK);
      break;

    case 10:
      TrackZoomingVolume(state, x, y, TRACK, state->view->curVol);
      break;

    case 11:
      TrackMovingPhantomEye(state, x, y, TRACK); 
      break;

    case 12:
      TrackResettingPhantomEye(state, x, y, TRACK);
      break;
    }
    break;

  case ButtonRelease:
    if ((((button-1) % 3) + 1) != input->event->xbutton.button)
      break;

    EndInteractiveMode( state );

    switch (button) {
    case 1:
      TrackMovingVolume(state, x, y, TRACK_END, -1);

      // Install the spin handling routine, if appropriate
      if (state->view->autoSpin)
        RegisterWorkProc();
      break;

    case 2:
      if (match == -1)
	TrackPickingPlanes(state, x, y, TRACK_END);
      else {
	TrackMovingSurface(state, x, y, match, TRACK_END);
	if (noSurfaceBeforeMove) {
	  noSurfaceBeforeMove = FALSE;
	  state->view->curSurf = -1;
	  state->view->stateChanged = TRUE;
	  RedrawWindows();
	}
      }
      break;

    case 3:
      TrackMovingSlicePlane(state, x, y, TRACK_END);
      break;

    case 4:
      TrackZoomingVolume(state, x, y, TRACK_END, -1);
      break;

    case 5:
      TrackPickingPoints(state, x, y, TRACK_END);
      break;

    case 6:
      TrackDrivingSlicePlane(state, x, y, TRACK_END);
      break;

    case 7:
      TrackMovingVolume(state, x, y, TRACK_END, state->view->curVol);

      // Disable per volume auto spin, Brian claims it is more annoying than useful
      state->volumeData[state->view->curVol]->autoSpin = FALSE;

      // Install the spin handling routine, if appropriate
      if (state->volumeData[state->view->curVol]->autoSpin)
        RegisterWorkProc();
      break;

    case 8:
      TrackMovingXYVolume(state, x, y, TRACK_END);
      break;

    case 9:
      TrackMovingZVolume(state, x, y, TRACK_END);
      break;

    case 10:
      TrackZoomingVolume(state, x, y, TRACK_END, state->view->curVol);
      break;

    case 11:
      TrackMovingPhantomEye(state, x, y, TRACK_END);
      break;

    case 12:
      TrackResettingPhantomEye(state, x, y, TRACK_END);
      break;
    }

    button = 0;
    break;
  }
}


void RenderWindow::Redraw(Widget, XtPointer)
{
  RedrawWindow( state );
}


void RenderWindow::Resize(Widget, XtPointer caData)
{
#ifdef VR_IRISGL
  GlxDrawCallbackStruct *resize = (GlxDrawCallbackStruct*) caData;
#endif

#ifdef VR_OPENGL
  GLwDrawingAreaCallbackStruct *resize = (GLwDrawingAreaCallbackStruct*) caData;
#endif

  state->view->width = resize->width;
  state->view->height = resize->height;
  state->view->aspect = ((float) state->view->width) / state->view->height;
  RedrawWindow( state );

#ifndef VR_AUXBUFFER
  state->view->auxWidth = state->view->width / 2;
  state->view->auxHeight = state->view->height;
#endif
}


void RenderWindow::BeginInteractiveMode( VRState *state )
{
  state->mode->interactive = TRUE;
  state->view->delta = SLICE_FACTOR / state->view->deltas[INTERACTIVE];
}


void RenderWindow::EndInteractiveMode( VRState *state )
{
  state->mode->interactive = FALSE;
  state->view->delta = SLICE_FACTOR / state->view->deltas[NONINTERACTIVE];
}


void RenderWindow::RegisterWorkProc()
{
  if (workprocID == 0)
    workprocID = XtAppAddWorkProc(theApplication->appContext(),
                                  &RenderWindow::WorkCallback, (XtPointer) this);
}


Boolean RenderWindow::Work()
{
  if ( (state->view->debug == 8) && state->view->autoSpin )
    printf( "Auto updating for spin...\n" );

  if ( (state->view->debug == 8) && state->mode->loopMode )
    printf( "Auto updating for loop...\n" );

  if ( state->mode->loopMode )
    state->planeData->stateChanged = TRUE;

  RedrawWindows();

  // Only return true if we are done spinning and looping
  int done = True;

  if ( state->view->autoSpin || state->mode->loopMode ) {
    done = False;
  } else {
    for (int volNumber=0; volNumber<state->world->nVols; volNumber++)
      if (state->volumeData[volNumber]->autoSpin) {
	done = False;
	break;
      }
  }

  // If the workproc is done we must zero the ID!
  if (done)
    workprocID = 0;

  return( done );
}


void RenderWindow::UpdateRotationMatrix( float degrees )
{
   int           i, j;
   float         d;
   static float  r = 0;
   static matrix m, rotMat;
   int           MatricesEqual;

   MatricesEqual = TRUE;

   for ( i = 0; i < 4; i++ )
   {
      for ( j = 0; j < 4; j++ )
      {
	 MatricesEqual &= (m[i][j] == state->view->RotMat[i][j]);
      }
   }

   if ( MatricesEqual == FALSE )
      r = 0;

   r += degrees;

   printf( "Axial rotation = %f\n", r );

   d = sin(degrees/180.0/2 * M_PI);

   ComputeVsphereMatrix( state,
			 state->view->width  / 2,
			 state->view->height / 2,
			 d * state->view->width/2, 0,
			 rotMat, False );
   matrix_mult_safe(rotMat, state->view->RotMat, state->view->RotMat);
   matrix_transpose(state->view->RotMat, 4, state->view->InvRotMat);

   matrix_copy( state->view->RotMat, 4, m );
}


void RenderWindow::HandleKey(char key, int)
{
  int i, j, v;
  VRVolumeData *vd;
  VRSurfaceData *sd;
  IndexCallbackStruct ic;
  char msg[256];

  // Default message is no message at all
  msg[0] = NULL;

  Focus();

  if (state->world->initing)
    return;

  switch (key) {

    // Ignore tab releases that come through
  case '\t':
    break;

  case 033:
  case 'Q':
    theApplication->quitYourself();
    sprintf(msg, "Exiting...");
    break;

  case '!':
    state->view->verbose = !state->view->verbose;
    state->view->stateChanged = TRUE;
    sprintf(msg, "Verbose mode is %s.", state->view->verbose ? "on" : "off");
    break;

  case '?':
    ResetVRState( state );
    mainWindow->UpdateState();
    sprintf(msg, "Reset state.");
    break;
	
  case ':':
    if (!state->world->allowStereoMode) {
      NotifyError("You cannot enable stereo mode because the stereo flag (-e) was not given!", FALSE);
      break;
    }
      
    FocusView( state );
    state->world->stereoMode = !state->world->stereoMode;
    state->mode->stateChanged = TRUE;

    if ( state->world->stereoMode ) {

      char *monitor = getenv("VOLREN_STEREO_MONITOR");
      if ( monitor == NULL )
	system( "/usr/gfx/setmon 815x611_120s </dev/null >/dev/null 2>/dev/null" );
      else {
	char command[256];
	sprintf( command,  "/usr/gfx/setmon %s </dev/null >/dev/null 2>/dev/null", monitor );
	system( command );
      }

      state->mode->pixelResSave = state->mode->pixelRes;
      state->mode->pixelRes = True;

    } else {

      char *monitor = getenv("VOLREN_MONO_MONITOR");
      if ( monitor == NULL )
	system( "/usr/gfx/setmon 1280x1024_60 </dev/null >/dev/null 2>/dev/null" );
      else {
	char command[256];
	sprintf( command,  "/usr/gfx/setmon %s </dev/null >/dev/null 2>/dev/null", monitor );
	system( command );
      }

      state->mode->pixelRes = state->mode->pixelResSave;
    }

    mainWindow->ResetParameterValues();
    sprintf(msg, "Stereo mode is %s.", state->world->stereoMode ? "on" : "off");
    break;

  case '*':
    SnapScreen(state);    // Make a snapshot of the screen
    break;

  case 'A':
    if (state->view->curVol == -1) {
      NotifyError("You cannot toggle alphamap modulation without a volume selected!", FALSE);
      break;
    }

    vd = state->volumeData[state->view->curVol];
    vd->modAmap = !vd->modAmap;
    vd->stateChanged = TRUE;

    UpdateTable(state, state->view->curVol);
    InstallTable(state, state->view->curVol);
    state->win->tlutWindow->Redraw();

    sprintf(msg, "Transfer function %s modify alphamap.", vd->modAmap ? "will" : "will not");
    break;

  case 'C':
    if (state->view->curVol == -1) {
      NotifyError("You cannot toggle colormap modulation without a volume selected!", FALSE);
      break;
    }

    vd = state->volumeData[state->view->curVol];
    vd->modCmap = !vd->modCmap;
    vd->stateChanged = TRUE;

    UpdateTable(state, state->view->curVol);
    InstallTable(state, state->view->curVol);
    state->win->tlutWindow->Redraw();

    sprintf(msg, "Transfer function %s modify colormap.", vd->modCmap ? "will" : "will not");
    break;

  case 'D':
    if (!state->world->define4BitBricks) {
      NotifyError("You cannot enable 4-bit mode because the 4-bit flag (-4) was not given!", FALSE);
      break;
    }
      
    state->mode->brickRes = !state->mode->brickRes;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Render %s-bit bricks.", state->mode->brickRes ? "4" : "8");
    break;

  case 'G':
    state->mode->clipGeomMode = !state->mode->clipGeomMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Geometry %s be clipped by clip planes.",
	    state->mode->clipGeomMode ? "will" : "will not");
    break;

  case 'I':
    if (state->view->curVol == -1) {
      NotifyError("You cannot toggle volume interpolating without a volume selected!", FALSE);
      break;
    }

    vd = state->volumeData[state->view->curVol];

    vd->drawInterp = !vd->drawInterp;
    vd->stateChanged = TRUE;
    sprintf(msg, "Volume #%d %s be linearly interpolated.", state->view->curVol+1,
	    vd->drawInterp ? "will" : "will not");
    break;
	
  case 'L':
    if (state->view->curSurf == -1) {
      NotifyError("You cannot toggle surface lighting without a surface selected!", FALSE);
      break;
    }

    sd = state->surfaceData[state->view->curSurf];

    sd->drawLighted = !sd->drawLighted;
    sd->stateChanged = TRUE;
    sprintf(msg, "Surface #%d %s be lighted.", state->view->curSurf+1,
	    sd->drawLighted ? "will" : "will not");
    break;
	
  case 'M':
    if (state->view->curSurf == -1) {
      NotifyError("You cannot toggle surface mesh rendering without a surface selected!", FALSE);
      break;
    }
    
    sd = state->surfaceData[state->view->curSurf];

    sd->drawMeshed = !sd->drawMeshed;
    sd->stateChanged = TRUE;
    sprintf(msg, "Surface #%d %s be drawn as a mesh.", state->view->curSurf+1,
	    sd->drawMeshed ? "will" : "will not");
    break;

  case 'N':
    state->mode->iaSurfMode = !state->mode->iaSurfMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Surfaces %s interactively follow points.",
	    state->mode->iaSurfMode ? "will" : "will not");
    break;

  case 'O':
    if (state->view->curVol == -1) {
      NotifyError("You cannot toggle volume coloring without a volume selected!", FALSE);
      break;
    }

    vd = state->volumeData[state->view->curVol];
    vd->drawColor = !vd->drawColor;

    UpdateTable(state, state->view->curVol);
    InstallTable(state, state->view->curVol);
    mainWindow->tlutWindow->Redraw();

    ReloadVolume(state, state->view->curVol);
    RedefVolume(state, state->view->curVol);

    vd->stateChanged = TRUE;
    sprintf(msg, "Volume #%d will be drawn in %s.", state->view->curVol+1,
	    vd->drawColor ? "color" : "black and white");
    break;
	
  case 'S':
    state->mode->iaSliderMode = !state->mode->iaSliderMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Rendering %s continue during transfer function parameter changes.",
	    state->mode->iaSliderMode ? "will" : "will not");
    break;

  case 'X':
    if (!state->world->doTexturedSurfs) {
      NotifyError("Unable to texture surface due to volume bricking format chosen!", FALSE);
      break;
    }
    if (state->view->curSurf == -1) {
      NotifyError("You cannot toggle surface texturing without a surface selected!", FALSE);
      break;
    }

    sd = state->surfaceData[state->view->curSurf];

    sd->drawTextured = !sd->drawTextured;
    sd->stateChanged = TRUE;
    sprintf(msg, "Surface #%d %s be drawn textured.", state->view->curSurf+1,
	    sd->drawTextured ? "will" : "will not");
    break;

  case 'a':
    state->mode->vectorMode = !state->mode->vectorMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Arrows %s be drawn.", state->mode->vectorMode ? "will" : "will not");
    break;
	
  case 'b':
    state->mode->mipMode = !state->mode->mipMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "%s blending will be used.",
	    state->mode->mipMode ? "Maximum intensity projection" : "Over");
    break;

  case 'c':
    if (state->mode->loopMode && state->mode->sliceMode) {
      NotifyError("You cannot disable clip planes while the clip planes are looping!", FALSE);
      break;
    }

    state->mode->sliceMode = !state->mode->sliceMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Clip planes %s be used.", state->mode->sliceMode ? "will" : "will not");
    break;

  case 'd':
    state->mode->frontbufMode = !state->mode->frontbufMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Double buffering %s be used.", state->mode->frontbufMode ? "will not" : "will");
    break;

  case 'e':
    state->mode->elevMode = !state->mode->elevMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Elevations %s be displayed.", state->mode->elevMode ? "will" : "will not");
    break;

  case 'f':
    state->mode->frameMode = !state->mode->frameMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Volume frames %s be displayed.", state->mode->frameMode ? "will" : "will not");
    break;

  case 'g':
    if (state->view->curSurf == -1) {
      NotifyError("You cannot create a surface without a surface selected!", FALSE);
      break;
    }

    sd = state->surfaceData[state->view->curSurf];

    if ( state->view->debug != 7 ) {

      VRPointData *pd = state->pointData[state->view->curSurf];

      if ( pd->nPoints < 3 ) {
	NotifyError("A minimum of three points are required to define a surface.\n"
		    "Try creating more points then generating the surface again.", TRUE);
	break;
      }

      CreateSurfaceFromPoints(state, pd, sd);

    } else {

      int xdir=0, ydir=1, zdir=2;
      int xt, yt, zt, t;

      xt = state->volumeData[0]->nxBricks;
      yt = state->volumeData[0]->nyBricks;
      zt = state->volumeData[0]->nzBricks;

      if        (state->world->surfaceNormal == 0) {
	xdir = zdir; zdir = state->world->surfaceNormal;
	t = xt; xt = zt; zt = t;
      } else if (state->world->surfaceNormal == 1) {
	ydir = zdir; zdir = state->world->surfaceNormal;
	t = yt; yt = zt; zt = t;
      }

      float *ptr = (float*) sd->polys;

      for (j=0; j<sd->polyHeight; j++)
	for (i=0; i<sd->polyWidth; i++) {
	  float x = i / (sd->polyWidth-1.0);
	  float y = j / (sd->polyHeight-1.0);;

	  *(ptr+xdir) = x * xt - (xt / 2.0);
	  *(ptr+ydir) = y * yt - (yt / 2.0);
	  x += ((float) state->view->curSurf) / (MAX_SURFS-1);
	  *(ptr+zdir) = (0.5 * sin(x*2.0*M_PI) * cos(y*2.0*M_PI) + 0.5) *
	                    zt - (zt / 2.0);
	  ptr += 3;
	}

      GenerateSurfaceNormals(sd->polys, state->world->surfaceNormal, 
			     sd->normals, sd->polyWidth, sd->polyHeight);

    }

    sd->haveSurf = TRUE;
    sd->stateChanged = TRUE;
    break;

  case 'h':
    state->mode->pixelRes = !state->mode->pixelRes;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Images will be rendered in %s resolution.",
	    state->mode->pixelRes ? "high" : "low");
    break;

  case 'l':
    // Toggle the looping
    state->mode->loopMode = !state->mode->loopMode;
    state->mode->stateChanged = TRUE;

    if ( state->mode->loopMode ) {

      // If we are beginning, save the slicing state
      state->mode->sliceModeSave = state->mode->sliceMode;

      // Turn on the slicing plane if necessary, updating the toggle button
      if (!state->mode->sliceMode)
	HandleKey('c', True);

    } else {

      // Turn off the slicing plane if it was off, updating the toggle button
      if (!state->mode->sliceModeSave)
	HandleKey('c', True);
    }

    // Install the cine loop handling routine, if appropriate
    if (state->mode->loopMode)
      if (workprocID == 0)
	workprocID = XtAppAddWorkProc(theApplication->appContext(),
				      &RenderWindow::WorkCallback, (XtPointer) this);
    break;
	
  case 'n':
    state->mode->pointsMode = !state->mode->pointsMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Points %s be displayed.", state->mode->pointsMode ? "will" : "will not");
    break;

  case 'p':
    state->mode->perspMode = !state->mode->perspMode;
    state->mode->stateChanged = TRUE;
    ComputePerspScale( state );
    mainWindow->ResetParameterValues();
    sprintf(msg, "Images %s be rendered in perspective.",
	    state->mode->perspMode ? "will" : "will not");
    break;

  case 'q':
    ReleaseTopLevelWindow( state );
    return;

  case 'r':
    RereadData(NULL, NULL);
    break;

  case 's':
    state->mode->surfaceMode = !state->mode->surfaceMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Surfaces %s be displayed.", state->mode->surfaceMode ? "will" : "will not");
    break;

  case 't':
    state->mode->textMode = !state->mode->textMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Text %s be displayed.", state->mode->textMode ? "will" : "will not");
    break;

  case 'v':
    state->mode->volumeMode = !state->mode->volumeMode;
    state->mode->stateChanged = TRUE;
    sprintf(msg, "Volumes %s be displayed.", state->mode->volumeMode ? "will" : "will not");
    break;

  case '0':  case '1':  case '2':  case '3':  case '4':
  case '5':  case '6':  case '7':  case '8':  case '9':
    v = key - '0' - 1;

    if (v < state->world->nVols) {
      ic._this = mainWindow;
      ic.index = v;
      mainWindow->VolumeSelectCallback(NULL, &ic, NULL);
    } else
      NotifyError("You cannot select a volume that was not loaded!", FALSE);

    break;
	
  case '+':  case '=':
    state->view->debug = (state->view->debug + 11) % 10;
    state->view->stateChanged = TRUE;
    sprintf(msg, "Entering debug mode #%d.", state->view->debug);
    break;
	
  case '-':  case '_':
    state->view->debug = (state->view->debug + 9) % 10;
    state->view->stateChanged = TRUE;
    sprintf(msg, "Entering debug mode #%d.", state->view->debug);
    break;

  default:			// If the key is undefined, it stops the spinning/looping
    if (workprocID != 0) {
      XtRemoveWorkProc(workprocID);
      workprocID = 0;
    }

    if (state->mode->loopMode)
      HandleKey('l', True);	// Turn off looping if it is on

    state->view->autoSpin = FALSE;
    state->view->stateChanged = TRUE;

    msg[0] = ' ';
    msg[1] = NULL;
    
    break;
  }

  mainWindow->ResetMenuValues();
  if (msg[0])
    mainWindow->UpdateStatusMessage(msg);
}


void RenderWindow::SetValue(Widget widget, String arg, XtArgVal value)
{
  Arg args[1];

  XtSetArg(args[0], arg, value);
  XtSetValues(widget, args, 1);
}


void RenderWindow::GetValue(Widget widget, String arg, XtArgVal value)
{
  Arg args[1];

  XtSetArg(args[0], arg, value);
  XtGetValues(widget, args, 1);
}


Boolean RenderWindow::WorkCallback(XtPointer clData)
{
  // Cast client data to this pointer
  RenderWindow *_this = (RenderWindow*) clData;

  // Call the appropriate callback with the widget and callback data
  return( _this->Work() );
}
