/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

//
// Create a X/Xt/IM window
//


#include "cppArgs.h"

#include <stdio.h>

#include "hciGLXWindow.H"


#ifdef VR_IRISGL
// Macro to simplify GLXconfig structure assignment in constructor
#define AssignConfig(config, stereo, rgb, doublebuf) \
       (config)[0].arg = (rgb); \
       (config)[1].arg = (doublebuf); \
       (config)[5].arg = (stereo);
#endif


GLXWindow::GLXWindow(const char* name, Widget parent, GLWindowType wt,
		     int width, int height)
  : VkComponent(name)
{
#ifdef VR_IRISGL
  int stereo = ((wt == StereoColorIndexSingle) || (wt == StereoColorIndexDouble) ||
		(wt == StereoRGBSingle)        || (wt == StereoRGBDouble));
#endif
		
  // Create the Mdraw widget, the actual GL window type
  // allocated will be stored in configWindow
  int n = 0;
  Arg args[25];


#ifdef VR_IRISGL
  GLXconfig configWindow[10];

  // Setup the window configuration arguments
  configWindow[0].buffer = GLX_NORMAL;
  configWindow[1].buffer = GLX_NORMAL;
  configWindow[2].buffer = GLX_NORMAL;
  configWindow[3].buffer = GLX_NORMAL;
  configWindow[4].buffer = GLX_NORMAL;
  configWindow[5].buffer = stereo ? GLX_NORMAL : 0;
  configWindow[6].buffer = 0;

  configWindow[0].mode = GLX_RGB;
  configWindow[1].mode = GLX_DOUBLE;
  configWindow[2].mode = GLX_STENSIZE;
  configWindow[3].mode = GLX_ZSIZE;
  configWindow[4].mode = GLX_RGBSIZE;
  configWindow[5].mode = stereo ? GLX_STEREOBUF : 0;
  configWindow[6].mode = 0;

  configWindow[0].arg = 1;
  configWindow[1].arg = 1;
  configWindow[2].arg = 0;
  configWindow[3].arg = 1;
  configWindow[4].arg = 1;
  configWindow[5].arg = 0;
  configWindow[6].arg = 0;

  switch (wt) {
  case MonoColorIndexSingle:
    AssignConfig(configWindow, False, False, False);
    break;
  case MonoColorIndexDouble:
    AssignConfig(configWindow, False, False, True);
    break;
  case MonoRGBSingle:
    AssignConfig(configWindow, False, True, False);
    break;
  case MonoRGBDouble:
    AssignConfig(configWindow, False, True, True);
    break;
  case StereoColorIndexSingle:
    AssignConfig(configWindow, True, False, False);
    break;
  case StereoColorIndexDouble:
    AssignConfig(configWindow, True, False, True);
    break;
  case StereoRGBSingle:
    AssignConfig(configWindow, True, True, False);
    break;
  case StereoRGBDouble:
    AssignConfig(configWindow, True, True, True);
    break;
  }

  XtSetArg(args[n], GlxNglxConfig, configWindow); n++;
#endif

#ifdef VR_OPENGL
    // Setup the window configuration arguments
  XtSetArg(args[n], GLwNdepthSize, 1); n++;
  XtSetArg(args[n], GLwNredSize, 1); n++;
  XtSetArg(args[n], GLwNgreenSize, 1); n++;
  XtSetArg(args[n], GLwNblueSize, 1); n++;
  XtSetArg(args[n], GLwNalphaSize, 0); n++;

  switch (wt) {
  case MonoColorIndexSingle:
      XtSetArg(args[n], GLwNrgba, False); n++;
      XtSetArg(args[n], GLwNdoublebuffer, False); n++;
      XtSetArg(args[n], GLwNstereo, False); n++;
      break;
  case MonoColorIndexDouble:
      XtSetArg(args[n], GLwNrgba, False); n++;
      XtSetArg(args[n], GLwNdoublebuffer, True); n++;
      XtSetArg(args[n], GLwNstereo, False); n++;
      break;
  case MonoRGBSingle:
      XtSetArg(args[n], GLwNrgba, True); n++;
      XtSetArg(args[n], GLwNdoublebuffer, False); n++;
      XtSetArg(args[n], GLwNstereo, False); n++;
      break;
  case MonoRGBDouble:
      XtSetArg(args[n], GLwNrgba, True); n++;
      XtSetArg(args[n], GLwNdoublebuffer, True); n++;
      XtSetArg(args[n], GLwNstereo, False); n++;
      break;
  case StereoColorIndexSingle:
      XtSetArg(args[n], GLwNrgba, False); n++;
      XtSetArg(args[n], GLwNdoublebuffer, False); n++;
      XtSetArg(args[n], GLwNstereo, True); n++;
      break;
  case StereoColorIndexDouble:
      XtSetArg(args[n], GLwNrgba, False); n++;
      XtSetArg(args[n], GLwNdoublebuffer, True); n++;
      XtSetArg(args[n], GLwNstereo, True); n++;
      break;
  case StereoRGBSingle:
      XtSetArg(args[n], GLwNrgba, True); n++;
      XtSetArg(args[n], GLwNdoublebuffer, False); n++;
      XtSetArg(args[n], GLwNstereo, True); n++;
      break;
  case StereoRGBDouble:
      XtSetArg(args[n], GLwNrgba, True); n++;
      XtSetArg(args[n], GLwNdoublebuffer, True); n++;
      XtSetArg(args[n], GLwNstereo, True); n++;
      break;
  }    
#endif

  XtSetArg(args[n], XtNwidth, width); n++;
  XtSetArg(args[n], XtNheight, height); n++;

#ifdef VR_IRISGL
  _baseWidget = GlxCreateMDraw(parent, (char*) name, args, n);

  // Setup window callbacks
  XtAddCallback(_baseWidget, GlxNginitCallback,
		&GLXWindow::InitCallback, (XtPointer) this);
  XtAddCallback(_baseWidget, GlxNinputCallback,
		&GLXWindow::InputCallback, (XtPointer) this);
  XtAddCallback(_baseWidget, GlxNexposeCallback,
		&GLXWindow::RedrawCallback, (XtPointer) this);
  XtAddCallback(_baseWidget, GlxNresizeCallback,
		&GLXWindow::ResizeCallback, (XtPointer) this);
#endif

#ifdef VR_OPENGL
  _baseWidget = GLwCreateMDrawingArea(parent, (char*) name, args, n);

  // Setup window callbacks
  XtAddCallback(_baseWidget, GLwNginitCallback,
		&GLXWindow::InitCallback, (XtPointer) this);
  XtAddCallback(_baseWidget, GLwNinputCallback,
		&GLXWindow::InputCallback, (XtPointer) this);
  XtAddCallback(_baseWidget, GLwNexposeCallback,
		&GLXWindow::RedrawCallback, (XtPointer) this);
  XtAddCallback(_baseWidget, GLwNresizeCallback,
		&GLXWindow::ResizeCallback, (XtPointer) this);
#endif

  // Setup callback to handle widget destruction
  installDestroyHandler();

  // Setup event handler to get button motion
  XtAddEventHandler(_baseWidget, ButtonMotionMask, False,
		    (XtEventHandler) &GLXWindow::MotionCallback, (XtPointer) this);
}


GLXWindow::~GLXWindow()
{
}


const char* GLXWindow::className()
{
#ifdef VR_IRISGL
  return( "GLXWindow" );
#endif

#ifdef VR_OPENGL
  return( "OGLXWindow" );
#endif
}


void GLXWindow::Init(Widget w, XtPointer)
{
  Window r;
  int t;
  unsigned int ut;

  window = XtWindow(w);
  display = XtDisplay(w);

  XGetGeometry(display, window, &r, &t, &t,
	       (unsigned int*) &width, (unsigned int*) &height, &ut, &ut);
  aspect = ((float) width) / height;

#ifdef VR_OPENGL
  Arg args[1];

  // Get the visual info
  XtSetArg(args[0], GLwNvisualInfo, &visualInfo);
  XtGetValues(w, args, 1);

  // Create a rendering context
  context = glXCreateContext(display, visualInfo, NULL, GL_TRUE);
  glXMakeCurrent(display, window, context);
#endif
}


void GLXWindow::Input(Widget, XtPointer)  {}
void GLXWindow::Redraw(Widget, XtPointer) {}
void GLXWindow::Resize(Widget, XtPointer) {}


void GLXWindow::Focus()
{
#ifdef VR_IRISGL
  GLXwinset(display, window);
  viewport(0, width-1, 0, height-1);
#endif

#ifdef VR_OPENGL
  glXMakeCurrent(display, window, context);
  glViewport(0, 0, width-1, height-1);
#endif
}


void GLXWindow::InitCallback(Widget w, XtPointer clData, XtPointer caData)
{
  // Cast client data to this pointer
  GLXWindow *_this = (GLXWindow*) clData;

  // Call the appropriate callback with the widget and callback data
  _this->Init(w, caData);
}


void GLXWindow::InputCallback(Widget w, XtPointer clData, XtPointer caData)
{
  // Cast client data to this pointer
  GLXWindow *_this = (GLXWindow*) clData;

  // Call the appropriate callback with the widget and callback data
  _this->Input(w, caData);
}


void GLXWindow::MotionCallback(Widget w, XtPointer clData,
			       XEvent *e, Boolean *b)
{
#ifdef VR_IRISGL
  GlxDrawCallbackStruct caData;
#endif

#ifdef VR_OPENGL
  GLwDrawingAreaCallbackStruct caData;
#endif

  // Cast client data to this pointer
  GLXWindow *_this = (GLXWindow*) clData;

  // Throw away all but the most recent mouse position
  while (XCheckMaskEvent(theApplication->display(), ButtonMotionMask, e));

  // Construct the callback struct so that we can simply call 'Input()'
  // Note: the 'Input()' must use only the 'event' data member!
  caData.event = e;

  // Call the appropriate callback with the widget and callback data
  _this->Input(w, &caData);

  *b = False;			// we have fully dealt with this event
}


void GLXWindow::RedrawCallback(Widget w, XtPointer clData, XtPointer caData)
{
  // Cast client data to this pointer
  GLXWindow *_this = (GLXWindow*) clData;

  // Call the appropriate callback with the widget and callback data
  _this->Redraw(w, caData);
}


void GLXWindow::ResizeCallback(Widget w, XtPointer clData, XtPointer caData)
{
  // Cast client data to this pointer
  GLXWindow *_this = (GLXWindow*) clData;

  // Call the appropriate callback with the widget and callback data
  _this->Resize(w, caData);
}
