/*
 * fmtexttorle.c - Use the IRIS font manager to display text then copy
 *               this text into a Utah rle file to be later composited
 *               on top of another image.
 *
 * Written by:  Wesley C. Barris
 *              AHPCRC
 *              Minnesota Supercomputer Center, Inc.
 * Date:        Apr. 1, 1991
 * Copyright @ 1991, Minnesota Supercomputer Center, Inc.
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 *
 * To compile and link this program, do this:
 * cc -O -o fmtexttorle fmtexttorle.c -lfm_s -lgl_s -lm
 *
 * Usage: fmtexttorle fontname size RRR GGG BBB string
 */
#include <stdio.h>
#include <string.h>
#include "gl.h"
#include "device.h"
#include "fmclient.h"

double atof();
#define LEFT	0
#define CENTER	1
#define RIGHT	2

int max(i1, i2)
int i1, i2;
{
   if (i1 > i2)
      return i1;
   else
      return i2;
}

main(argc, argv)
int	argc;
char	**argv;
{
   fmfonthandle	font1, fsized;
   fmfontinfo	finfo;
   fmglyphinfo	*fgs;
   char		cmd[80], achar;
   static unsigned long	*wbuf = NULL;
   FILE		*pixout;
   int		bufsiz, width, height, i, w;
   short	cv[4];
   double	scale;
   char		*strarr[20];
   int		nstr = 0;
   int		justify = LEFT;
   int		spec_char = 0;
   int		black_text = 0;
   long		bits24;
   long		gid;
/*
 *  Check input.
 */
   if (argc < 6) {
      fprintf(stderr, "Usage: fmtexttorle fontname size RRR GGG BBB string\n");
      fprintf(stderr, "Example: fmtexttorle Times-Roman 40.0 100 255 100 hello\n");
      exit(-1);
      }
   else if (argc == 6) { /* re-directing from a file or here document */
      strarr[nstr] = (char *)malloc(80);
      while (fgets(strarr[nstr], 80, stdin) != NULL)
         if (!strcmp(strarr[nstr], ".CENTER.\n"))
            justify = CENTER;
         else if (!strcmp(strarr[nstr], ".LEFT.\n"))
            justify = LEFT;
         else if (!strcmp(strarr[nstr], ".RIGHT.\n"))
            justify = RIGHT;
         else
            strarr[++nstr] = (char *)malloc(80);
      free(strarr[nstr]);
      }
/*                              0          1       2  3   4   5    6   */
   else if (argc == 7) { /* texttorle Times-Roman 30 255 255 255 Hello */
      strarr[nstr] = (char *)malloc(80);
      strcpy(strarr[nstr++], argv[6]);
      achar = argv[6][0];
      if (achar == '.')
         if (!strcmp(strarr[nstr-1], ".INTEGRAL.")) {
            spec_char = 243;
            strcpy(strarr[nstr-1], "W");
            nstr = 3;
            }
         else if (!strcmp(strarr[nstr-1], ".LBRACE.")) {
            spec_char = 236;
            strcpy(strarr[nstr-1], "W");
            nstr = 3;
            }
         else if (!strcmp(strarr[nstr-1], ".RBRACE.")) {
            spec_char = 252;
            strcpy(strarr[nstr-1], "W");
            nstr = 3;
            }
         else if (!strcmp(strarr[nstr-1], ".LBRACKET.")) {
            spec_char = 233;
            strcpy(strarr[nstr-1], "W");
            nstr = 3;
            }
         else if (!strcmp(strarr[nstr-1], ".RBRACKET.")) {
            spec_char = 249;
            strcpy(strarr[nstr-1], "W");
            nstr = 3;
            }
         else if (!strcmp(strarr[nstr-1], ".LPAREN.")) {
            spec_char = 230;
            strcpy(strarr[nstr-1], "W");
            nstr = 3;
            }
         else if (!strcmp(strarr[nstr-1], ".LPAREN.")) {
            spec_char = 246;
            strcpy(strarr[nstr-1], "W");
            nstr = 3;
            }
      else { /* must be a "dot command" */
         spec_char = atoi(strarr[nstr-1]+1);
         nstr = 1;
         }
      }
/*
 *  Init the font manager...
 */
   fminit();
   if ((font1=fmfindfont(argv[1])) == 0) {
      fprintf(stderr, "Can't open %s as a font.\n", argv[1]);
      exit(-1);
      }

   scale = atof(argv[2]);
   if (scale < 1.0 || scale > 100.0) {
      fprintf(stderr, "Invalid font size: %f\n", scale);
      exit(-1);
      }
   fsized = fmscalefont(font1, scale);
   fmsetfont(fsized);
   fmgetfontinfo(fsized, &finfo);
/*
 *  Determine the width of the required window.  This may be only one
 *  character wide or the widest of several strings.
 */
   if (spec_char) {
      fgs = (fmglyphinfo *)calloc((int)finfo.nglyphs, sizeof(fmglyphinfo));
      fmgetwholemetrics(fsized, fgs);
      width = 0;
      for (i=0; i<nstr; i++)
         width = max(width, fgs[spec_char+i].xsize - fgs[spec_char+i].xorig);
      height = fgs[spec_char].ysize*nstr;
      }
   else {
      for (i=0; i<nstr; i++)
         width = max(width, (int)fmgetstrwidth(fsized, strarr[i]));
      height = finfo.ysize * nstr;
      }
/*
 *  How many bit planes have we got?
 */
   bits24 = getgdesc(GD_BITS_NORM_SNG_RED);
/*
 *  Init graphics...
 */
   prefposition(10, 10 + width - 1, 10, 10 + height - 1);
   foreground();
   gid = winopen("SGI Fonts");
   if (bits24) {
      RGBmode();
      gconfig();
      cv[0] = 0;
      cv[1] = 0;
      cv[2] = 0;
      cv[3] = 0;
      c4s(cv);
      }
   else
      color(0);
   clear();
   cv[0] = atoi(argv[3]);
   cv[1] = atoi(argv[4]);
   cv[2] = atoi(argv[5]);
   cv[3] = 255;
   if (cv[0] < 0 || cv[0] > 255 ||
       cv[1] < 0 || cv[1] > 255 ||
       cv[2] < 0 || cv[2] > 255) {
      fprintf(stderr, "Invalid color value: %d %d %d\n", cv[1], cv[2], cv[3]);
      gexit();
      exit(-1);
      }
   if (cv[0] == 0 && cv[1] == 0 && cv[2] == 0) {
      black_text = 1;
      cv[0] = 1;
      }
/*
 *  Set the color value (or index) for text.
 */
   if (bits24)
      c4s(cv);
   else
      color(2);	/* any non-zero index will work */
/*
 *  Print all the strings.
 */
   for (i=0; i<nstr; i++) {
      if (spec_char) {
         cmov2i(0, fgs[spec_char+i].yorig + finfo.height*(nstr-i-1));
         fmoutchar(fsized, spec_char+i);
         }
      else {
         w = (int)fmgetstrwidth(fsized, strarr[i]);
         if (justify == CENTER)
            cmov2i((width-w)/2, finfo.yorig + finfo.ysize*(nstr-i-1));
         else if (justify == RIGHT)
            cmov2i(width-w, finfo.yorig + finfo.ysize*(nstr-i-1));
         else
            cmov2i(0, finfo.yorig + finfo.ysize*(nstr-i-1));
         fmprstr(strarr[i]);
         }
      }
/*
 *  Dump the image to a file.
 */
   bufsiz = width*height*4;
   if ((wbuf = (unsigned long *) malloc(bufsiz)) == NULL)
      fprintf(stderr, "Cannot malloc %d bytes.\n", bufsiz);
   lrectread(0, 0, width-1, height-1, wbuf);
/*
 * If the display has 24 bit planes, the only thing in question
 * is wheather or not we have alpha planes.
 */
   if (bits24) {
      if (getgdesc(GD_BITS_NORM_SNG_ALPHA) != 8)
         if (black_text) {
            for (i=0; i<width*height; i++)
               wbuf[i] = (wbuf[i] & 0x00FFFFFF ? 0xFF000000 : 0);
            }
         else {
            for (i=0; i<width*height; i++)
               wbuf[i] = (wbuf[i] & 0x00FFFFFF) |
                         (wbuf[i] & 0x00FFFFFF ? 0xFF000000 : 0);
            }
      }
   else	/* must only have 8 bits */
      for (i=0; i<width*height; i++) {
         wbuf[i] = ((wbuf[i] & 0x000000FF) ? cv[0]
                                          | (cv[1] << 8)
                                          | (cv[2] << 16)
                                          | (cv[3] << 24) : 0);
         }
/*
 *  Make an RLE file.
 */
   sprintf(cmd,"/usr/local/Utah/bin/rawtorle -w %d -h %d -n 4 -r",width,height);
   if ((pixout = popen(cmd, "w")) == NULL)
      fprintf(stderr, "Cannot open pipe.\n");
   if ((fwrite(wbuf, bufsiz, 1, pixout)) != 1)
      fprintf(stderr, "Cannot write command to pipe.\n");
   pclose(pixout);
/*
 *  Close up shop.
 */
   winclose(gid);
   gexit();
   return 0;
}
