#
# khoros.pl
#
# khoros perl library v0.2
# Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
#
# TODO
#	1.	need a general mail-reporting mechanism, whereby perl scripts
#		can mail a report back to the user.  Currently kmakeall and
#		ksrcconf have hardwired references to mush.  This needs to be
#		configurable.
#		(neilb 8-apr-94)

package khoros;

# Major and Minor versions of the Perl library
# ------------------------------------------------------------------------
$KPERL_MAJOR=0;
$KPERL_MINOR=2;

# Required Khoros environment variables
# ------------------------------------------------------------------------
@khoros_environment = ('KHOROS_MAIL', 'KHOROS_TOOLBOX');

# Standard Khoros command line switches
# ------------------------------------------------------------------------
@khoros_std_args =
   (
    '[V]',		'',		'display version of %P',
    '[U]',		'',		'display usage for %P'
    );

sub initialize
{
   local($toolbox,$whatis,@local_args) = @_;

   $progname = $0;
   $progname =~ s#.*/##;
   $kwhatis = $whatis;
   $main'progname = $progname; #'
   &get_environment;
   &kinit_args(@local_args);
}

sub get_environment
{
   foreach $kvar (@khoros_environment)
   {
      next if eval("\$main'$kvar = \$ENV{\"$kvar\"}");
      &kerror("The $kvar environment variable must be set.");
   }
   $KNOTIFY = "STANDARD" unless ($KNOTIFY = $ENV{"KHOROS_NOTIFY"});
   @KHOROS_TOOLBOXES = split(/:/,$main'KHOROS_TOOLBOX);
}

sub parse_args
{
   local(@argv) = @_;
   local(@remainder) = ();

   if (@argv == 1 && $argv[0] =~ /([^:]+)::([^:]+)/)
   {
      @argv = ('-tb', $1, '-oname', $2);
   }

 ARGLOOP:
   while (@argv > 0) {
      $arg = shift(@argv);
      (@remainder=(@remainder,$arg)),next ARGLOOP if $arg =~ /^[^-]/;
      $arg =~ s/^-//;
      &kerror("unrecognized switch -$arg") unless defined $switch_type{$arg};
      $seenswitch{$arg} = 1;
      next ARGLOOP unless $arg_type{$arg};
      $argval = shift(@argv);
      ($argval{$arg}=$argval),next ARGLOOP if $arg_type{$arg} == 1;
      unshift(@argv,$argval),next ARGLOOP if $argval =~ /^-/;
      $argval{$arg}=$argval;
   }
   &usage if $seenswitch{"U"};
   &version if $seenswitch{"V"};
   foreach $switch (@switchlist)
   {
      if ($switch_type{$switch} == 0 && !$seenswitch{$switch} &&
	  $switch ne '-')
      {
	 die "\n\t-$switch switch is required.\n";
	 # &usage;
      }
   }
   return @remainder;
}

sub kinfo
{
   local($notify_type,$message,@kvalist) = @_;

   if (@kvalist > 0)
   {
      printf STDERR ($message,@kvalist);
   }
   else
   {
      printf STDERR ($message);
   }
}

sub kerror
{
   local($message) = @_;

   die "$progname: $message\n";
}

sub kinit_args
{
   @arglist = (@_, @khoros_std_args);
 
   $index=0;
   $swindex=0;
   for ($i = 0; $i < @arglist / 3; ++$i)
   {
      $arg = $arglist[$index++];
      $arg =~ /(\[?)([^\]]+)(\]?)/;
      if ($2 ne '-')
      {
	 $switch = $switchlist[$swindex++] = $2;
	 $switch_type{$switch} = ($1 eq '[');
	 $switchstr = "$1-$2";
      }
      else
      {
	 $tailargs = $arglist[$index++];
	 $taildesc = $arglist[$index++];
	 next;
      }

      # get details of argument
      $pdef = $arglist[$index++];
      unless ($pdef)
      {
	 $arg_type{$switch} = 0;
      }
      else
      {
	 $switchstr .= " $pdef";
	 $pdef =~ /(\[?)([^\]]+)(\]?)/;
	 $arg_type{$switch} = 1 + ($1 eq '[');
	 $arg_name{$switch} = $2;
      }
      $switchstr .= ']' if $switch_type{$switch};
      $switchstr{$switch} = $switchstr;

      $_ = $arglist[$index++];
      s/%P/$progname/g;
      $switch_desc{$switch} = $_;
   }
}

# ========================================================================
# Routine Name: usage - display usage statement
#
# Purpose:      This function displays the usage statement for the perl
#               program which included this file.
#
# Input:        none
# ========================================================================
sub usage
{
   print STDERR "\n$progname:  $kwhatis\n\n";
   print STDERR "usage:\n    $progname";
   if (defined($tailargs))
   {
      $max=length($tailargs);
   }
   else
   {
      $max=0;
   }
   foreach $switch (@switchlist)
   {
      $max=length($switchstr{$switch}) if length($switchstr{$switch})>$max;
      print STDERR " $switchstr{$switch}";
   }
   print STDERR " $tailargs" if defined($tailargs);
   print STDERR "\n\nwhere:\n";
   foreach $switch (@switchlist)
   {
      print STDERR "    $switchstr{$switch}";
      $offset = 2 + $max - length($switchstr{$switch});
      print STDERR ' ' x ($offset);
      print STDERR "$switch_desc{$switch}\n";
   }
   if (defined($tailargs))
   {
      print STDERR "    $tailargs";
      print STDERR ' ' x (2 + $max -length($tailargs));
      print STDERR "$taildesc\n";
   }
   print STDERR "\n";
   exit(0);
}

# ========================================================================
# Routine Name: toolbox_path - get the path to a specified toolbox
#
# Purpose:      This function takes the name of a toolbox and returns the
#               fullpath to the top of the toolbox structure.
#
# Input:        toolbox - name of the toolbox.
# ========================================================================
sub version
{
   print STDERR "\nToolbox Version:\n";
   print STDERR "\tKhoros 2.0a\n";
   print STDERR "\tSupport 2.0\n";
   print STDERR "\nProgram Version:\n";
   print STDERR "\t$progname 2.1\n\n";
   print STDERR "Perl library version $KPERL_MAJOR.$KPERL_MINOR\n\n";
   exit(0);
}

# ========================================================================
# Routine Name: toolbox_path - get the path to a specified toolbox
#
# Purpose:      This function takes the name of a toolbox and returns the
#               fullpath to the top of the toolbox structure.
#
# Input:        toolbox - name of the toolbox.
# ========================================================================
sub toolbox_path
{
   local($toolbox) = @_;

   foreach $tbfile (@KHOROS_TOOLBOXES)
   {
      open(TOOLBOX,"< $tbfile") || die "can't open toolbox file\n";
      while (<TOOLBOX>)
      {
	 chop;
	 ($tb,$path) = split(/:/,$_,3);
	 close(TOOLBOX),return $path if $tb eq $toolbox;
      }
      close(TOOLBOX);
   }
   &kerror("toolbox $toolbox not in @KHOROS_TOOLBOXES.");
}

# ========================================================================
# Routine Name: read_toolbox_mach - read default mach file for a toolbox
#
# Purpose:      This function is used to read the default mach file for
#               a specified toolbox.
#
# Input:        toolbox - name of the toolbox to read the mach file for.
# ========================================================================
sub read_toolbox_mach
{
   local($toolbox) = @_;
   local($srcmachHome,$tbHome,$machfile);

   $srcmachHome	= &toolbox_path("SRCMACH");
   $machfile	= "$srcmachHome/repos/config/src_conf/${toolbox}_mf";

   &read_mach_file($toolbox,$machfile);
}


# ========================================================================
# Routine Name: read_mach_file - read a specificed toolbox mach file
#
# Purpose:      This function is used to enable remote shell (rsh).
#               This is currently effected by linking .rhosts to .rhosts.bk.
#               If the latter file does not exist, an error message is
#               given.
#
# Input:        toolbox  - name of the toolbox the mach file is for.
#               machfile - full path to the mach file we want to read in.
# ========================================================================
sub read_mach_file
{
   local($toolbox,$machfile) = @_;
   local($TOOLBOX) = $toolbox;
   local($tbHome);

   $toolbox =~ s/(.*)/\L$1/;		# lower case toolbox name
   $TOOLBOX =~ s/(.*)/\U$1/;		# upper case toolbox name

   $tbHome		= &toolbox_path($TOOLBOX);

   open(MACH,"<$machfile") || &kerror("can't read mach file $machfile");
   while (<MACH>)
   {
      s/#.*$//;
      s/\$$TOOLBOX/$tbHome/g;

      eval("\@$1 = split(/\\s+/,\"$2\")") if /set\s+(\S+)\s*=\s*\(([^)]+)\)/;

   }
   close(MACH);

   # consistency checking for info read from mach file
   &kerror("KHOROS_USER must be defined in mach file $MACH.")
							unless @KHOROS_USER;
   $main'KHOROS_USER	= $KHOROS_USER[0]; # '
   (($n,$p,$u,$g,$q,$c,$gc,$main'USER_HOME)=getpwnam($main'KHOROS_USER))
				|| &kerror("user $main'KHOROS_USER not known");

   &kerror("must be at least one machine defined in mach file $machfile")
			unless @KHOROS_MACHINES;
   &kerror("incorrect number of fields in mach file $machfile")
      unless @KHOROS_MACHINES == @KHOROS_MACH_DIR &&
	 @KHOROS_MACHINES == @KHOROS_SRC_TOP;
   @main'KHOROS_MACHINES = @KHOROS_MACHINES; #'
   @main'KHOROS_MACH_DIR = @KHOROS_MACH_DIR; #'
   @main'KHOROS_SRC_TOP	 = @KHOROS_SRC_TOP;  #'

   &kerror("LOCAL_SRC_TOP must be defined in mach file $MACH.")
                                                unless @LOCAL_SRC_TOP;
   $main'LOCAL_SRC_TOP	= $LOCAL_SRC_TOP[0]; #'
   &kerror("LOCAL_SRC_TOP (@LOCAL_SRC_TOP) in $MACH not a directory.")
      unless -d $main'LOCAL_SRC_TOP;
}

# ========================================================================
# Routine Name: enable_rsh - enable remote shell
#
# Purpose:      This function is used to enable remote shell (rsh).
#               This is currently effected by linking .rhosts to .rhosts.bk.
#               If the latter file does not exist, an error message is
#               given.
#
# Input:        none
# ========================================================================
sub enable_rsh
{
   local($user) = @_;
   local($n,$p,$uid,$gid,$q,$cmnt,$gcos,$dir,$sh) = getpwnam($user);

   return if -e "$dir/.rhosts";
   &kerror("please create a .rhosts.bk file in ~$user")
					unless -e "$dir/.rhosts.bk";
   link("$dir/.rhosts.bk","$dir/.rhosts");
}

# ========================================================================
# Routine Name: disable_rsh - disable remote shell
#
# Purpose:      This function is used to disable remote shell.
#               either specified with a -tb switch, or as a fallback,
#               the routine will open an Imakefile in the current directory.
#               and use the toolbox name found therein.
#
# Input:        none
# ========================================================================
sub disable_rsh
{
   local($user) = @_;
   local($n,$p,$uid,$gid,$q,$cmnt,$gcos,$dir,$sh) = getpwnam($user);

   unlink("$dir/.rhosts") if -e "$dir/.rhosts";
}

# ========================================================================
# Routine Name: get_tb_name
#
# Purpose:      This function is used to get the toolbox name, which is
#               either specified with a -tb switch, or as a fallback,
#               the routine will open an Imakefile in the current directory.
#               and use the toolbox name found therein.
#
# Input:        none
# ========================================================================
sub get_tb_name
{
   return $khoros'argval{"tb"} if defined $khoros'argval{"tb"};

   &kerror("Imakefile not present, I can't determine toolbox name")
      unless -f "Imakefile";
   open(IMAKEFILE,"<Imakefile") || &kerror("can't read Imakefile");
   while (<IMAKEFILE>)
   {
      close(IMAKEFILE),return $1 if /^TOOLBOX_NAME\s+=\s+(\S+)/;
   }
   close(IMAKEFILE);
   &kerror("Couldn't determine TOOLBOX name from Imakefile");
}

# ========================================================================
# Function:	fullpath()
#
# Purpose:	Resolve a path, expanding out any leading toolbox references.
# ========================================================================
sub fullpath
{
   local($path) = @_;
   local($toolbox);

   print STDERR "Expanding: $path\n" if $verbose;
   if ($path =~ m!\$([^/]+)/(.*)$!)
   {
      $toolbox = "\U$1";
      unless (defined $toolboxPath{"$toolbox"})
      {
         # warn "Could not resolve path: $path (toolbox \$$toolbox unknown)\n";
         return undef;
      }
      $path = "$toolboxPath{$toolbox}/$2";
   }

   return $path;
}

# ========================================================================
# Function:	GetToolboxPaths()
#
# Purpose:	Build an associative array %toolboxPath, indexed on toolbox
#		name, which holds the fullpath to the top of the toolbox.
# ========================================================================
sub GetToolboxPaths
{
   return unless defined $ENV{'KHOROS_TOOLBOX'};
   @TBFILES = split(/:/,$ENV{'KHOROS_TOOLBOX'});
   foreach $file (@TBFILES)
   {
      open(TBFILE, "<$file") || next;
      while (<TBFILE>)
      {
         chop;
         ($toolbox, $tbpath) = split(/:/);
         $toolboxPath{$toolbox} = $tbpath;
      }
   }
}

sub query_toolboxes
{
   return sort keys %toolboxPath;
}

# ========================================================================
# Function:	get_toolbox_list()
# Purpose:	This function returns a list of toolboxes.  If the -tb
#		switch was given, then that is split on `,', to get
#		a list of one or more toolboxes.  Otherwise, the default
#		is to return a list of all known toolboxes.
# ========================================================================
sub get_toolbox_list
{
   if ($seenswitch{'tb'})
   {
      return split(/,/, $argval{'tb'});
   }
   else
   {
      return &query_toolboxes();
   }
}

sub update_find_file
{
   local($path, $update_regex, @update_table) = @_;
   local(*oldfn);
   local(@match_regex);
   local(@substitute_regex);


   if (@update_table % 2 != 0)
   {
      warn "update_file_find(): Incorrect number of entries in update table\n";
      return;
   }

   while (@update_table > 0)
   {
      push(@match_regex, shift update_table);
      push(@substitute_regex, shift update_table);
   }

   *oldfn = *main'wanted;
   *main'wanted = *update_find_file_wanted;
   &main'find($path);
   *main'wanted = *oldfn;
}

sub update_find_file_wanted
{
   /$update_regex/ && &regex_update($main'name);
}

sub regex_update
{
   local($filename) = @_;
   local(*INFILE);
   local(*OUTFILE);
   local($newfile);
   local($updated);


   $newfile = "$filename.$$";
   print "   $filename ... ";
   open(INFILE, "< $filename") || do
   {
      warn "could not open: $!\n";
      return;
   };

   open(OUTFILE, "> $newfile") || do
   {
      close(INFILE);
      print STDERR "could not write $newfile: $!\n";
      return;
   };

   $updated = 0;
   while (<INFILE>)
   {
      for ($i = 0; $i < @match_regex; ++$i)
      {
	 /$match_regex[$i]/ && do
	 {
	    print "MATCHED ON: $match_regex[$i]\n";
	    s/$match_regex[$i]/$substitute_regex[$i]/;
	    $updated = 1;
	 };
      }

      print OUTFILE;
   }
   close INFILE;
   close OUTFILE;

   if ($updated)
   {
      rename($filename, "$filename.bak") && rename($newfile, $filename);
      print "UPDATED.\n";
   }
   else
   {
      print "unchanged.\n";
      unlink($newfile);
   }
}

&GetToolboxPaths();
1;
